﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pctl/detail/service/overlay/pctl_OverlaySender.h>

#include <nn/os/os_Event.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace overlay {

// Windows では何もしないため仮定義を置く

// 自動テストで利用できるように無名名前空間の外に定義
struct NotifiedDataSettingChange
{
    nn::os::EventType event;
    nn::ovln::format::PctlSettingTypeFlagSet settingType;
    bool isNotified;
};
struct NotifiedDataRemainingTime
{
    nn::os::EventType event;
    int32_t time;
    nn::ovln::format::PctlPlayTimerModeFlag modeFlag;
    bool isNotified;
};
struct NotifiedDataUnlink
{
    nn::os::EventType event;
    nn::ovln::format::PctlUnlinkReasonFlag reason;
    bool isNotified;
};
struct NotifiedDataTimeExceededOnStart
{
    nn::os::EventType event;
    int64_t time;
    nn::ovln::format::PctlPlayTimerModeFlag modeFlag;
    bool isNotified;
};
struct NotifiedDataAlarmSettingChanged
{
    nn::os::EventType event;
    nn::ovln::format::PctlAlarmSettingFlag flag;
    bool isNotified;
};

namespace
{
    NotifiedDataSettingChange g_NotifiedDataSettingChange = { 0 };
    NotifiedDataRemainingTime g_NotifiedDataRemainingTime = { 0 };
    NotifiedDataUnlink g_NotifiedDataUnlink = { 0 };
    NotifiedDataTimeExceededOnStart g_NotifiedDataTimeExceededOnStart = { 0 };
    NotifiedDataAlarmSettingChanged g_NotifiedDataAlarmSettingChanged = { 0 };
}

nn::Result InitializeOverlaySender() NN_NOEXCEPT
{
    nn::os::InitializeEvent(&g_NotifiedDataSettingChange.event, false, nn::os::EventClearMode_ManualClear);
    nn::os::InitializeEvent(&g_NotifiedDataRemainingTime.event, false, nn::os::EventClearMode_ManualClear);
    nn::os::InitializeEvent(&g_NotifiedDataUnlink.event, false, nn::os::EventClearMode_ManualClear);
    nn::os::InitializeEvent(&g_NotifiedDataTimeExceededOnStart.event, false, nn::os::EventClearMode_ManualClear);
    nn::os::InitializeEvent(&g_NotifiedDataAlarmSettingChanged.event, false, nn::os::EventClearMode_ManualClear);
    return nn::ResultSuccess();
}

void FinalizeOverlaySender() NN_NOEXCEPT
{
    nn::os::FinalizeEvent(&g_NotifiedDataAlarmSettingChanged.event);
    nn::os::FinalizeEvent(&g_NotifiedDataTimeExceededOnStart.event);
    nn::os::FinalizeEvent(&g_NotifiedDataUnlink.event);
    nn::os::FinalizeEvent(&g_NotifiedDataRemainingTime.event);
    nn::os::FinalizeEvent(&g_NotifiedDataSettingChange.event);
}

nn::Result NotifySettingChangedImpl(nn::ovln::format::PctlSettingTypeFlagSet settingType) NN_NOEXCEPT
{
    g_NotifiedDataSettingChange.settingType = settingType;
    g_NotifiedDataSettingChange.isNotified = true;
    nn::os::SignalEvent(&g_NotifiedDataSettingChange.event);
    return nn::ResultSuccess();
}

nn::Result NotifyPlayTimerRemainingTimeImpl(int16_t remainingTime, nn::ovln::format::PctlPlayTimerModeFlag mode) NN_NOEXCEPT
{
    g_NotifiedDataRemainingTime.time = remainingTime;
    g_NotifiedDataRemainingTime.modeFlag = mode;
    g_NotifiedDataRemainingTime.isNotified = true;
    nn::os::SignalEvent(&g_NotifiedDataRemainingTime.event);
    return nn::ResultSuccess();
}

nn::Result NotifyUnlinkImpl(nn::ovln::format::PctlUnlinkReasonFlag reason) NN_NOEXCEPT
{
    g_NotifiedDataUnlink.reason = reason;
    g_NotifiedDataUnlink.isNotified = true;
    nn::os::SignalEvent(&g_NotifiedDataUnlink.event);
    return nn::ResultSuccess();
}

nn::Result NotifyTimeExceededOnStartImpl(int64_t exceedingTime, nn::ovln::format::PctlPlayTimerModeFlag mode) NN_NOEXCEPT
{
    g_NotifiedDataTimeExceededOnStart.time = exceedingTime;
    g_NotifiedDataTimeExceededOnStart.modeFlag = mode;
    g_NotifiedDataTimeExceededOnStart.isNotified = true;
    nn::os::SignalEvent(&g_NotifiedDataTimeExceededOnStart.event);
    return nn::ResultSuccess();
}

nn::Result NotifyAlarmSettingChangedImpl(nn::ovln::format::PctlAlarmSettingFlag flag) NN_NOEXCEPT
{
    g_NotifiedDataAlarmSettingChanged.flag = flag;
    g_NotifiedDataAlarmSettingChanged.isNotified = true;
    nn::os::SignalEvent(&g_NotifiedDataAlarmSettingChanged.event);
    return nn::ResultSuccess();
}

// 自動テスト用
NotifiedDataSettingChange* GetNotifiedDataSettingChange() NN_NOEXCEPT
{
    return &g_NotifiedDataSettingChange;
}

NotifiedDataRemainingTime* GetNotifiedDataRemainingTime() NN_NOEXCEPT
{
    return &g_NotifiedDataRemainingTime;
}

NotifiedDataUnlink* GetNotifiedDataUnlink() NN_NOEXCEPT
{
    return &g_NotifiedDataUnlink;
}

NotifiedDataTimeExceededOnStart* GetNotifiedDataTimeExceededOnStart() NN_NOEXCEPT
{
    return &g_NotifiedDataTimeExceededOnStart;
}

NotifiedDataAlarmSettingChanged* GetNotifiedDataAlarmSettingChanged() NN_NOEXCEPT
{
    return &g_NotifiedDataAlarmSettingChanged;
}

}}}}}
