﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pctl/detail/service/common/pctl_Constants.h>

#include <type_traits>
#include <nn/nn_StaticAssert.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace common {

using nn::ns::RatingOrganization;

const SafetyLevelSettings SafetyLevelPresetSettings[SafetyLevel::SafetyLevel_Max] = {
    // SafetyLevel::SafetyLevel_None
    { 0, false, false },
    // SafetyLevel::SafetyLevel_Custom (使用しない)
    { 0, false, false },
    // SafetyLevel::SafetyLevel_Children
    { 7, true, true },
    // SafetyLevel::SafetyLevel_YoungTeens
    { 12, true, true },
    // SafetyLevel::SafetyLevel_OlderTeens
    { 16, false, false }
};
const SafetyLevelSettings SafetyLevelPresetSettingsForJapan[SafetyLevel::SafetyLevel_Max] = {
    // SafetyLevel::SafetyLevel_None
    { 0, false, false },
    // SafetyLevel::SafetyLevel_Custom (使用しない)
    { 0, false, false },
    // SafetyLevel::SafetyLevel_Children
    { 7, true, true },
    // SafetyLevel::SafetyLevel_YoungTeens
    { 12, true, true },
    // SafetyLevel::SafetyLevel_OlderTeens
    { 16, false, true } // 日本のみ「freeCommunicationRestriction」が異なる
};
// ※ 既定値の組み合わせの詳細: http://spdlybra.nintendo.co.jp/confluence/pages/viewpage.action?pageId=210741003
const RatingOrganization DefaultRatingOrganizations[] = {
    // RegionForDefaultRatingOrganization::Others (使用されないはず)
        // LanguageForDefaultRatingOrganization::Others
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::English
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::French
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::Spanish
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::Italian
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::Dutch
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::Japanese
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::German
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::Portuguese
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::Russian
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::TraditionalChinese
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::SimplifiedChinese
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::Korean
        RatingOrganization::CERO,
    // RegionForDefaultRatingOrganization::Japan
        // LanguageForDefaultRatingOrganization::Others
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::English
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::French
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::Spanish
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::Italian
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::Dutch
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::Japanese
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::German
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::Portuguese
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::Russian
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::TraditionalChinese
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::SimplifiedChinese
        RatingOrganization::CERO,
        // LanguageForDefaultRatingOrganization::Korean
        RatingOrganization::CERO,
    // RegionForDefaultRatingOrganization::NorthAmerica
        // LanguageForDefaultRatingOrganization::Others
        RatingOrganization::ESRB,
        // LanguageForDefaultRatingOrganization::English
        RatingOrganization::ESRB,
        // LanguageForDefaultRatingOrganization::French
        RatingOrganization::ESRB,
        // LanguageForDefaultRatingOrganization::Spanish
        RatingOrganization::ESRB,
        // LanguageForDefaultRatingOrganization::Italian
        RatingOrganization::ESRB,
        // LanguageForDefaultRatingOrganization::Dutch
        RatingOrganization::ESRB,
        // LanguageForDefaultRatingOrganization::Japanese
        RatingOrganization::ESRB,
        // LanguageForDefaultRatingOrganization::German
        RatingOrganization::ESRB,
        // LanguageForDefaultRatingOrganization::Portuguese
        RatingOrganization::ESRB,
        // LanguageForDefaultRatingOrganization::Russian
        RatingOrganization::ESRB,
        // LanguageForDefaultRatingOrganization::TraditionalChinese
        RatingOrganization::ESRB,
        // LanguageForDefaultRatingOrganization::SimplifiedChinese
        RatingOrganization::ESRB,
        // LanguageForDefaultRatingOrganization::Korean
        RatingOrganization::ESRB,
    // RegionForDefaultRatingOrganization::Europe
        // LanguageForDefaultRatingOrganization::Others
        RatingOrganization::PEGI,
        // LanguageForDefaultRatingOrganization::English
        RatingOrganization::PEGIBBFC,
        // LanguageForDefaultRatingOrganization::French
        RatingOrganization::PEGI,
        // LanguageForDefaultRatingOrganization::Spanish
        RatingOrganization::PEGI,
        // LanguageForDefaultRatingOrganization::Italian
        RatingOrganization::PEGI,
        // LanguageForDefaultRatingOrganization::Dutch
        RatingOrganization::PEGI,
        // LanguageForDefaultRatingOrganization::Japanese
        RatingOrganization::PEGI,
        // LanguageForDefaultRatingOrganization::German
        RatingOrganization::USK,
        // LanguageForDefaultRatingOrganization::Portuguese
        RatingOrganization::PEGIPortugal,
        // LanguageForDefaultRatingOrganization::Russian
        RatingOrganization::Russian,
        // LanguageForDefaultRatingOrganization::TraditionalChinese
        RatingOrganization::PEGI,
        // LanguageForDefaultRatingOrganization::SimplifiedChinese
        RatingOrganization::PEGI,
        // LanguageForDefaultRatingOrganization::Korean
        RatingOrganization::PEGI,
    // RegionForDefaultRatingOrganization::Australia
        // LanguageForDefaultRatingOrganization::Others
        RatingOrganization::ACB,
        // LanguageForDefaultRatingOrganization::English
        RatingOrganization::ACB,
        // LanguageForDefaultRatingOrganization::French
        RatingOrganization::ACB,
        // LanguageForDefaultRatingOrganization::Spanish
        RatingOrganization::ACB,
        // LanguageForDefaultRatingOrganization::Italian
        RatingOrganization::ACB,
        // LanguageForDefaultRatingOrganization::Dutch
        RatingOrganization::ACB,
        // LanguageForDefaultRatingOrganization::Japanese
        RatingOrganization::ACB,
        // LanguageForDefaultRatingOrganization::German
        RatingOrganization::ACB,
        // LanguageForDefaultRatingOrganization::Portuguese
        RatingOrganization::ACB,
        // LanguageForDefaultRatingOrganization::Russian
        RatingOrganization::ACB,
        // LanguageForDefaultRatingOrganization::TraditionalChinese
        RatingOrganization::ACB,
        // LanguageForDefaultRatingOrganization::SimplifiedChinese
        RatingOrganization::ACB,
        // LanguageForDefaultRatingOrganization::Korean
        RatingOrganization::ACB,
};

NN_STATIC_ASSERT(
    DefaultRatingOrganizationsCount == static_cast<decltype(DefaultRatingOrganizationsCount)>(
        std::extent<decltype(DefaultRatingOrganizations)>::value
        )
);

}}}}}
