﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pctl/detail/pctl_Npns.h>

#include <nn/pctl/detail/pctl_NpnsErrorHandler.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
#include <nn/npns/npns_ApiSystem.h>
#endif

namespace nn { namespace pctl { namespace detail {

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
namespace
{
    static bool g_IsNpnsInitialized = false;

    nn::Result PrepareNpnsImpl() NN_NOEXCEPT
    {
        NN_RESULT_DO(nn::npns::Suspend());
        NN_UTIL_SCOPE_EXIT
        {
            NN_ABORT_UNLESS_RESULT_SUCCESS(nn::npns::Resume());
        };
        // JIDが無ければ作成する
        {
            char jid[nn::npns::JidLength + 1];
            auto result = nn::npns::GetJid(jid, std::extent<decltype(jid)>::value);
            if (result.IsSuccess())
            {
                NN_RESULT_SUCCESS;
            }
        }
        NN_RESULT_DO(nn::npns::CreateJid());

        NN_RESULT_SUCCESS;
    }
}
#endif

nn::Result PrepareNpns() NN_NOEXCEPT
{
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    if (!g_IsNpnsInitialized)
    {
        NN_RESULT_DO(ConvertNpnsError(nn::npns::InitializeForSystem()));
        g_IsNpnsInitialized = true;
    }
    return ConvertNpnsError(PrepareNpnsImpl());
#else
    // 非Horizonでは何もしない
    NN_RESULT_SUCCESS;
#endif
}

}}}
