﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/pctl/detail/ipc/pctl_IpcSession.h>
#include <nn/pctl/detail/ipc/pctl_IParentalControlServiceFactory.sfdl.h>

#include <nn/os/os_SdkMutex.h>
#include <nn/sf/sf_ShimLibraryUtility.h>
#include <nn/sm/sm_Result.h>
#include <nn/util/util_LockGuard.h>

namespace nn { namespace pctl { namespace detail { namespace ipc {

namespace
{
    nn::os::SdkRecursiveMutexType g_MutexHolder = NN_OS_SDK_RECURSIVE_MUTEX_INITIALIZER();
}

// Finalize を行う場合は以下の処理
#if defined(NN_DETAIL_PCTL_CONFIG_USE_FINALIZE_SESSION)
void FinalizeIpcSession() NN_NOEXCEPT
{
    NN_UTIL_LOCK_GUARD(g_MutexHolder);
    FinalizeIpcSessionImpl();
}
#endif

IParentalControlService* GetService() NN_NOEXCEPT
{
    NN_UTIL_LOCK_GUARD(g_MutexHolder);
    NN_ABORT_UNLESS_RESULT_SUCCESS(InitializeIpcSessionIfNeeded());
    return GetServiceImpl();
}

IParentalControlService* GetServiceForWatcher() NN_NOEXCEPT
{
    NN_UTIL_LOCK_GUARD(g_MutexHolder);
    NN_ABORT_UNLESS_RESULT_SUCCESS(InitializeIpcSessionIfNeeded());
    NN_ABORT_UNLESS_RESULT_SUCCESS(InitializeWatcherIpcSessionIfNeeded());
    return GetServiceImpl();
}

}}}}
