﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;


namespace nn.pcie
{
   [CppRefPath(@"<nn/pcie/pcie_Types.h>")]
   [ExternalStruct(4, 4)]
   public struct RegionFlagMask{}
   [CppRefPath(@"<nn/pcie/pcie_Types.h>")]
   [ExternalStruct(4, 4)]
   public struct FunctionHandle{}
   [CppRefPath(@"<nn/pcie/pcie_Types.h>")]
   [ExternalStruct(24, 8)]
   public struct ClassDriverConfig{}
   [CppRefPath(@"<nn/pcie/pcie_Types.h>")]
   [ExternalStruct(4, 4)]
   public struct BusAccessWidth{}
   [CppRefPath(@"<nn/pcie/pcie_Types.h>")]
   [ExternalStruct(4, 4)]
   public struct DmaDirection{}
   [CppRefPath(@"<nn/pcie/pcie_Types.h>")]
   [ExternalStruct(8, 8)]
   public struct BusAddress{}
   [CppRefPath(@"<nn/pcie/pcie_Types.h>")]
   [ExternalStruct(4, 4)]
   public struct IrqType{}
   [CppRefPath(@"<nn/pcie/pcie_Types.h>")]
   [ExternalStruct(4, 4)]
   public struct FunctionResetOptionMask{}
   [CppRefPath(@"<nn/pcie/pcie_Standard.h>")]
   [ExternalStruct(4, 4)]
   public struct CapabilityId{}
   [CppRefPath(@"<nn/pcie/pcie_Standard.h>")]
   [ExternalStruct(4, 4)]
   public struct ExtendedCapabilityId{}

}

namespace nn.pcie.detail
{
    [CppRefPath("\"pcie_ISession.h\"")]
    interface ISession : IServiceObject
    {
    [MethodId(0)]
        Result QueryFunctions(nn.sf.OutBuffer outFunctions, Out<int32_t> outCount);

    [MethodId(1)]
        Result AcquireFunction( Out<NativeHandle> eventHandle, FunctionHandle functionHandle);

    [MethodId(2)]
        Result ReleaseFunction(FunctionHandle functionHandle);

    [MethodId(3)]
        Result GetFunctionState(nn.sf.OutBuffer output, FunctionHandle functionHandle);

    [MethodId(4)]
        Result GetBarProfile(Out<uint64_t> outBase, Out<uint64_t> outSize, Out<RegionFlagMask> outRegionFlagMask, FunctionHandle functionHandle, uint8_t bar);

    [MethodId(5)]
        Result ReadConfig(Out<uint32_t> dataOut, FunctionHandle functionHandle, uint32_t offset, BusAccessWidth width);

    [MethodId(6)]
        Result WriteConfig(uint32_t dataIn, FunctionHandle functionHandle, uint32_t offset, BusAccessWidth width);

    [MethodId(7)]
        Result ReadBarRegion([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer] nn.sf.OutBuffer output, FunctionHandle functionHandle, uint8_t bar, uint32_t offset, BusAccessWidth accessWidth);

    [MethodId(8)]
        Result WriteBarRegion([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer] nn.sf.InBuffer input, FunctionHandle functionHandle, uint8_t bar, uint32_t offset, BusAccessWidth accessWidth);

    [MethodId(9)]
        Result FindCapability(Out<uint32_t> offsetOut, FunctionHandle functionHandle, CapabilityId capabilityId);

    [MethodId(10)]
        Result FindExtendedCapability(Out<uint32_t> offsetOut, FunctionHandle functionHandle, ExtendedCapabilityId extendedCapabilityId);

    [MethodId(11)]
        Result MapDma(Out<BusAddress> busAddressOut, FunctionHandle functionHandle, DmaDirection direction, uint64_t procVa, uint32_t size);

    [MethodId(12)]
        Result UnmapDmaByProcVa(FunctionHandle functionHandle, uint64_t procVa);

    [MethodId(13)]
        Result UnmapDmaByBusAddress(FunctionHandle functionHandle, BusAddress busAddress);

    [MethodId(14)]
        Result GetDmaBusAddress(Out<BusAddress> busAddressOut, FunctionHandle functionHandle, uint64_t procVa, uint32_t size);

    [MethodId(15)]
        Result GetDmaBusAddressRange(Out<BusAddress> outBase, Out<BusAddress> outSize, FunctionHandle functionHandle);

    [MethodId(16)]
        Result SetDmaEnable(FunctionHandle functionHandle, bool isBusMasterEnabled);

    [MethodId(17)]
        Result AcquireIrq(Out<NativeHandle> eventHandle, FunctionHandle functionHandle, IrqType irqType);

    [MethodId(18)]
        Result ReleaseIrq(FunctionHandle functionHandle);

    [MethodId(19)]
        Result SetIrqEnable(FunctionHandle functionHandle, int32_t zeroBasedIrqNumber, bool isIrqEnabled);

    [MethodId(20)]
        Result SetAspmEnable(FunctionHandle functionHandle, bool isEnabled);

    [MethodId(21)]
        Result SetResetUponResumeEnable(FunctionHandle functionHandle, bool isEnabled);

    [MethodId(22)]
        Result ResetFunction(FunctionHandle functionHandle, FunctionResetOptionMask FunctionResetOptionMask);
    }

    // Manager class that returns ISession upon class driver registration
    [CppRefPath("\"pcie_IManager.h\"")]
    interface IManager : IServiceObject
    {
        [MethodId(0)]
        Result RegisterClassDriver(Out<ISession> outSession, Out<NativeHandle> registrationEventHandle, ClassDriverConfig config, NativeHandle processHandle);

        [MethodId(1)]
        Result QueryFunctions(nn.sf.OutBuffer outFunctions, Out<int32_t> outCount);
    }

    // Manager class used only for accessing logged data
    [CppRefPath("\"pcie_ILoggedStateManager.h\"")]
    interface ILoggedStateManager : IServiceObject
    {
        [MethodId(0)]
        Result GetLoggedState(nn.sf.OutBuffer output, Out<bool>isLoggedStatePendingOut, bool isCleared);

        [MethodId(1)]
        Result GetLoggedStateEvent(Out<NativeHandle> loggedStateEventHandle, bool isStatisticReported);
    }
}
