﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/nn_Common.h>

#include <nn/sf/sf_Types.h>
#include "detail/pcie_IManager.h"
#include "detail/pcie_ILoggedStateManager.h"

namespace nn { namespace pcie {

nn::sf::SharedPointer<detail::IManager> CreateManagerByHipc() NN_NOEXCEPT;
nn::sf::SharedPointer<detail::IManager> CreateManagerByDfc() NN_NOEXCEPT;

nn::sf::SharedPointer<detail::ILoggedStateManager> CreateLoggedStateManagerByHipc() NN_NOEXCEPT;
nn::sf::SharedPointer<detail::ILoggedStateManager> CreateLoggedStateManagerByDfc() NN_NOEXCEPT;

}}
