﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief Memory allocator
 *
 * @details This module provides basic memory allocation
 */

namespace nn { namespace pcie { namespace detail {

void MemoryInit(void *pBase, size_t size);
void MemoryFinalize();

void* MemoryAllocAligned(size_t size, size_t alignment);
void* MemoryAllocAligned(size_t size, size_t alignment, const char *objectname);
void* MemoryAlloc(size_t size);
void* MemoryAlloc(size_t size, const char *objectname);
void* MemoryCalloc(size_t size, const char *objectName);
void* MemoryCallocAligned(size_t size, size_t alignment, const char *objectName);
void  MemoryFree(void *pMem);
void  MemoryFree(void *pMem, const char *objectName);
size_t MemoryGetTotalFreeSize();

} // end of namespace detail
} // end of namespace usb0
} // end of namespace nn

