﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/olsc/srv/transfer/olsc_TransferUtil.h>

#include <nn/crypto/crypto_Md5Generator.h>
#include <nn/fs/fs_SaveDataTransferVersion2.h>

namespace nn { namespace olsc { namespace srv { namespace transfer {

Result GetExportSizeByDryRun(size_t* outValue, SaveDataChunkDigest* pOutDigest, fs::ISaveDataDivisionExporter* pExporter, fs::SaveDataChunkId id, void* buffer, size_t bufferSize) NN_NOEXCEPT
{
    size_t size = 0;
    std::unique_ptr<fs::ISaveDataChunkExporter> chunkExporter;
    NN_RESULT_DO(pExporter->OpenSaveDataChunkExporter(&chunkExporter, id));

    nn::crypto::Md5Generator md5;
    md5.Initialize();

    while(NN_STATIC_CONDITION(true))
    {
        size_t pulledSize = 0;
        NN_RESULT_DO(chunkExporter->Pull(&pulledSize, buffer, bufferSize));
        if (pulledSize <= 0)
        {
            NN_SDK_ASSERT(pulledSize == 0);
            break;
        }
        md5.Update(buffer, pulledSize);
        size += pulledSize;
    }

    md5.GetHash(pOutDigest->data, sizeof(pOutDigest->data));
    *outValue = size;
    NN_RESULT_SUCCESS;
}

}}}} //namespace nn::olsc::srv::transfer

