﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "olsc_Downloader.h"
#include "../adaptor/olsc_ComponentFileInfoAdaptor.h"

#include <nn/olsc/srv/transfer/olsc_ComponentFileDownload.h>
#include <nn/olsc/srv/transfer/olsc_SaveDataArchiveDownload.h>
#include <nn/olsc/srv/transfer/olsc_TransferUtil.h>
#include <nn/util/util_TFormatString.h>

namespace nn { namespace olsc { namespace srv { namespace transfer {

Result GetComponentFileSignedUrlForDownload(ComponentFileInfo* pOut, ComponentFileId id, const NsaIdToken& nsaIdToken, CURL* curlHandle, void* workBuffer, size_t workBufferSize, const nn::util::Cancelable* pCancelable) NN_NOEXCEPT
{
    // URL の作成
    char url[256];
    auto l = CreateUrlForGetComponentFileInfo(url, sizeof(url), id);
    NN_SDK_ASSERT(static_cast<uint32_t>(l) < sizeof(url));
    NN_UNUSED(l);

    adaptor::ComponentFileInfoMemoryOutputStream outputStream(pOut, 1); // 最大 1 つ
    adaptor::ComponentFileInfoAdaptor adaptor(&outputStream);

    char jsonString[128];

    l = nn::util::TSNPrintf(jsonString, sizeof(jsonString),
        "{"
             "\"permissions\": [\"read\"]"
        "}");

    NN_RESULT_DO(PostImpl(adaptor, nsaIdToken, url, jsonString, curlHandle, workBuffer, workBufferSize, pCancelable));

    NN_SDK_ASSERT(outputStream.GetCount() == 1);
    NN_RESULT_SUCCESS;
}


Result RequestDownloadComponentFile(size_t* pOutSize, void* outBuffer, size_t bufferSize, const char* url, size_t downloadSize, CURL* curlHandle, const nn::util::Cancelable* pCancelable) NN_NOEXCEPT
{
    NN_SDK_ASSERT(bufferSize >= downloadSize);
    NN_UNUSED(bufferSize);
    MemoryDownloader downloader(curlHandle, pCancelable);
    NN_RESULT_DO(downloader.Initialize());
    NN_RESULT_DO(downloader.SetTimeoutSeconds(static_cast<int32_t>(GetTransferTimeout(downloadSize).GetSeconds())));
    NN_RESULT_DO(downloader.SetUrl(url));
    NN_RESULT_DO(downloader.Download(pOutSize, outBuffer, downloadSize));
    NN_RESULT_SUCCESS;
}

Result RequestImportComponentFile(fs::ISaveDataChunkImporter* importer, const char* url, size_t importSize, CURL* curlHandle, void* workBuffer, size_t workBufferSize, const nn::util::Cancelable* pCancelable) NN_NOEXCEPT
{
    FsImporterDownloader downloader(curlHandle, pCancelable);
    NN_RESULT_DO(downloader.Initialize());
    NN_RESULT_DO(downloader.SetTimeoutSeconds(static_cast<int32_t>(GetTransferTimeout(importSize).GetSeconds())));
    NN_RESULT_DO(downloader.SetUrl(url));
    // もらったワークバッファをそのまま inputBuffer とする
    downloader.SetInputBuffer(workBuffer, workBufferSize);
    NN_RESULT_DO(downloader.Download(importer));
    NN_RESULT_SUCCESS;
}


}}}} //namespace nn::olsc::srv::transfer

