﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/olsc/olsc_Result.h>
#include <nn/olsc/olsc_ResultPrivate.h>
#include <nn/olsc/srv/olsc_AsyncResultImpl.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace olsc { namespace srv {

Result AsyncResultImplBase::Initialize(util::Executable& executable, util::AbstractExecutor& executor) NN_NOEXCEPT
{
    NN_SDK_ASSERT(!m_AsyncExecution);
    util::optional<util::AsyncExecution> obj(util::in_place, &executable);
    NN_RESULT_DO(obj->Initialize(&executor));
    m_AsyncExecution = std::move(obj);
    m_Executable = &executable;
    NN_RESULT_SUCCESS;
}
void AsyncResultImplBase::Finalize() NN_NOEXCEPT
{
    if (m_AsyncExecution)
    {
        m_AsyncExecution = util::nullopt;
    }
}
Result AsyncResultImplBase::GetResult() NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_AsyncExecution);
    NN_RESULT_THROW_UNLESS(m_Executable->HasDone(), olsc::ResultInvalidProtocolAccess());
    auto executableResult = m_Executable->TryGetResult();
    return executableResult ? *executableResult : olsc::ResultCanceledBeforeExecution();
}
Result AsyncResultImplBase::Cancel() NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_AsyncExecution);
    m_AsyncExecution->Cancel();
    NN_RESULT_SUCCESS;
}
Result AsyncResultImplBase::IsAvailable(sf::Out<bool> pOut) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_AsyncExecution);
    *pOut = m_Executable->HasDone();
    NN_RESULT_SUCCESS;
}
Result AsyncResultImplBase::GetSystemEvent(sf::Out<sf::NativeHandle> outValue) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_AsyncExecution);
    *outValue = sf::NativeHandle(m_Executable->GetReadableHandle(), false);
    NN_RESULT_SUCCESS;
}

}}} //namespace nn::olsc::srv

