﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_SaveDataTransferVersion2.h>
#include <nn/http/json/http_JsonPath.h>
#include <nn/olsc/srv/adaptor/olsc_AdaptorBase.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace olsc { namespace srv { namespace adaptor {

class KeySeedPackageBuilder
{
public:
    static const int MaxPropertyCount = 1;

    KeySeedPackageBuilder() NN_NOEXCEPT;
    void Reset() NN_NOEXCEPT;
    bool Validate() NN_NOEXCEPT;
    const fs::SaveDataTransferManagerVersion2::KeySeedPackage& GetKeySeedPackage() const NN_NOEXCEPT;
    template<typename FlagType>
    void SetFlag() NN_NOEXCEPT;

    template<typename FlagType>
    bool IsUnset() const NN_NOEXCEPT;

    void SetKeySeedPackage(const char ksp[], size_t kspSize) NN_NOEXCEPT;

private:
    fs::SaveDataTransferManagerVersion2::KeySeedPackage m_KeySeedPackage;
    nn::util::BitFlagSet<MaxPropertyCount> m_Imported;
};

class KeySeedPackageAdaptor
    : public AdaptorBase<8, 128>
{
public:
    KeySeedPackageAdaptor() NN_NOEXCEPT = default;

    virtual bool UpdateImpl(const JsonPathType& jsonPath, const char* value, int valueLength) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool NotifyObjectBeginImpl(const JsonPathType& jsonPath) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool NotifyObjectEndImpl(const JsonPathType& jsonPath) NN_NOEXCEPT NN_OVERRIDE;
    Result GetKeySeedPackage(fs::SaveDataTransferManagerVersion2::KeySeedPackage* pOutKsp) const NN_NOEXCEPT;

    static const int MaxPathLength = 64;

private:
    bool MakeAndCheckObjectPath(char* buffer, size_t bufferSize, const JsonPathType& jsonPath) NN_NOEXCEPT;

private:
    KeySeedPackageBuilder m_Builder;

    char m_PathBuffer[MaxPathLength];
    int m_PathBufferLength = 0;
    bool m_IsAcceptable = false;
};

}}}} // namespace nn::olsc::srv::adaptor
