﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/http/json/http_JsonPath.h>
#include <nn/nn_Result.h>
#include <nn/olsc/srv/adaptor/olsc_AdaptorBase.h>
#include "olsc_OutputStream.h"
#include <nn/olsc/srv/olsc_InternalTypes.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace olsc { namespace srv { namespace adaptor {

class ComponentFileInfoBuilder
{
public:
    static const int MaxPropertyCount = 32;

    ComponentFileInfoBuilder() NN_NOEXCEPT;
    void Reset() NN_NOEXCEPT;
    bool Validate() NN_NOEXCEPT;
    const ComponentFileInfo& GetComponentFileInfo() const NN_NOEXCEPT;

    template<typename FlagType>
    void SetFlag() NN_NOEXCEPT;

    template<typename FlagType>
    bool IsUnset() const NN_NOEXCEPT;

    void SetId(ComponentFileId componentFileId) NN_NOEXCEPT;
    void SetDataSize(size_t dataSize) NN_NOEXCEPT;
    void SetSaveDataArchiveId(SaveDataArchiveId saveDataArchiveId) NN_NOEXCEPT;
    void SetComponentFileSize(size_t dataSize) NN_NOEXCEPT;
    void SetSaveDataChunkSize(size_t dataSize) NN_NOEXCEPT;
    void SetEncodedComponentFileDigest(const ComponentFileDigest& digest) NN_NOEXCEPT;
    void SetEncodedSaveDataChunkDigest(const SaveDataChunkDigest& digest) NN_NOEXCEPT;
    void SetIndex(nn::fs::SaveDataChunkId chunkId) NN_NOEXCEPT;
    void SetCreatedAtAsUnixTime(const time::PosixTime& time) NN_NOEXCEPT;
    void SetUpdatedAtAsUnixTime(const time::PosixTime& time) NN_NOEXCEPT;
    void SetDataType(ComponentFileType type) NN_NOEXCEPT;
    void SetStatus(ComponentFileStatus status) NN_NOEXCEPT;
    void SetGetUrl(const void* url, size_t urlLength) NN_NOEXCEPT;
    void SetPutUrl(const void* url, size_t urlLength) NN_NOEXCEPT;

private:
    ComponentFileInfo m_ComponentFileInfo;
    nn::util::BitFlagSet<MaxPropertyCount> m_Imported;
};

class ComponentFileInfoAdaptor
    : public AdaptorBase<8, 128>
{
public:
    NN_IMPLICIT ComponentFileInfoAdaptor(ComponentFileInfoMemoryOutputStream* outputStream) NN_NOEXCEPT
        : m_OutputStream(outputStream)
    {}

    virtual bool UpdateImpl(const JsonPathType& jsonPath, int64_t value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool UpdateImpl(const JsonPathType& jsonPath, const char* value, int valueLength) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool NotifyObjectBeginImpl(const JsonPathType& jsonPath) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool NotifyObjectEndImpl(const JsonPathType& jsonPath) NN_NOEXCEPT NN_OVERRIDE;

    static const int MaxPathLength = 64;

private:
    bool MakeAndCheckObjectPath(char* buffer, size_t bufferSize, const JsonPathType& jsonPath) const NN_NOEXCEPT;

private:
    ComponentFileInfoMemoryOutputStream* m_OutputStream;
    ComponentFileInfoBuilder m_Builder;

    int m_CurrentIndex = 0;
    char m_PathBuffer[MaxPathLength];
    int m_PathBufferLength = 0;
    bool m_IsAcceptable = false;
};

}}}} // namespace nn::olsc::srv::adaptor
