﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/olsc/olsc_ForbiddenSaveDataIndication.h>

#include <algorithm>

#include <nn/olsc/sfdl/olsc_IOlscService.sfdl.h>
#include <nn/sf/sf_ISharedObject.h>

namespace nn { namespace olsc {

void swap(ForbiddenSaveDataIndication& lhs, ForbiddenSaveDataIndication& rhs) NN_NOEXCEPT
{
    std::swap(lhs.m_pImpl, rhs.m_pImpl);
}

ForbiddenSaveDataIndication::ForbiddenSaveDataIndication(ForbiddenSaveDataIndication&& rhs) NN_NOEXCEPT
    : m_pImpl(std::move(rhs.m_pImpl))
{
    rhs.m_pImpl = nullptr;
}
ForbiddenSaveDataIndication::ForbiddenSaveDataIndication(srv::IForbiddenSaveDataIndication* pImpl) NN_NOEXCEPT
    : m_pImpl(pImpl)
{
    NN_SDK_ASSERT_NOT_NULL(m_pImpl);
}
ForbiddenSaveDataIndication::~ForbiddenSaveDataIndication() NN_NOEXCEPT
{
    if (m_pImpl)
    {
        sf::ReleaseSharedObject(m_pImpl);
    }
}
ForbiddenSaveDataIndication& ForbiddenSaveDataIndication::operator =(ForbiddenSaveDataIndication&& rhs) NN_NOEXCEPT
{
    ForbiddenSaveDataIndication tmp = std::move(rhs);
    swap(*this, tmp);
    return *this;
}

void ForbiddenSaveDataIndication::Update(const ncm::ApplicationId appIds[], int count) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(m_pImpl);

    static const auto BufferCount = 32;
    ApplicationId buffer[BufferCount];

    auto offset = 0;
    while (offset < count)
    {
        const auto CpCount = std::min(BufferCount, count - offset);
        for (auto i = 0; i < CpCount; ++ i)
        {
            buffer[i] = {appIds[offset + i].value};
        }
        NN_ABORT_UNLESS_RESULT_SUCCESS(m_pImpl->Update(sf::InArray<ApplicationId>(buffer, CpCount)));
        offset += CpCount;
    }
}

}} // ~namespace nn::olsc
