﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn
{
    internal static class PathInfo
    {
        public const string Prefix = "<";
        public const string Postfix = ">";
        public const string Root = @"nn";
        public const string ApplicationIdPath = Prefix + Root + @"/nn_ApplicationId.h" + Postfix;
    }

    [CppRefPath(PathInfo.ApplicationIdPath)]
    [ExternalStruct(8, 8)]
    public struct ApplicationId
    {
    }
}

namespace nn.account
{
    internal static class PathInfo
    {
        public const string Prefix = "<";
        public const string Postfix = ">";
        public const string Root = @"nn/account";
        public const string AccountTypesPath = Prefix + Root + @"/account_Types.h" + Postfix;
    }

    [CppRefPath(PathInfo.AccountTypesPath)]
    [ExternalStruct(16, 8)]
    public struct Uid
    {
    }

}

namespace nn.olsc
{
    internal static class PathInfo
    {
        public const string Prefix = "<";
        public const string Postfix = ">";
        public const string Root = @"nn/olsc";
        public const string DataTypesPath = Prefix + Root + @"/olsc_DataTypes.h" + Postfix;
        public const string TransferTaskTypesPath = Prefix + Root + @"/olsc_TransferTaskTypes.h" + Postfix;
        public const string TransferTaskTypesForPrivatePath = Prefix + Root + @"/olsc_TransferTaskTypesForPrivate.h" + Postfix;
        public const string DataTypePath = Prefix + Root + @"/olsc_DataTypes.h" + Postfix;
    }

    [CppRefPath(PathInfo.DataTypesPath)]
    [ExternalStruct(8, 8)]
    public struct DataId
    {
    }

    [CppRefPath(PathInfo.TransferTaskTypesPath)]
    [ExternalStruct(48, 8)]
    public struct TransferTaskInfo
    {
    }

    [CppRefPath(PathInfo.TransferTaskTypesPath)]
    [ExternalStruct(8, 8)]
    public struct TransferTaskId
    {
    }

    [CppRefPath(PathInfo.TransferTaskTypesForPrivatePath)]
    [ExternalStruct(24, 8)]
    public struct TransferTaskProgressForIpc
    {
    }

    [CppRefPath(PathInfo.TransferTaskTypesPath)]
    [ExternalStruct(1, 1)]
    public struct TransferTaskKind
    {
    }

    [CppRefPath(PathInfo.TransferTaskTypesPath)]
    [ExternalStruct(48, 8)]
    public struct TransferTaskErrorInfo
    {
    }

    [CppRefPath(PathInfo.DataTypePath)]
    [ExternalStruct(64, 8)]
    public struct DataInfo
    {
    }

    [CppRefPath(PathInfo.DataTypePath)]
    [ExternalStruct(2, 1)]
    public struct DataTransferPolicy
    {
    }

    [CppRefPath(PathInfo.DataTypePath)]
    [ExternalStruct(1, 1)]
    public struct DataNewness
    {
    }

    [Serializable]
    [AttributeUsage(AttributeTargets.Parameter, AllowMultiple = true)]
    public class NotEmptyAttribute : PreAttribute
    {
        public NotEmptyAttribute()
            : base("_.GetData() != nullptr && _.GetLength() > 0")
        {
        }
    }
}

namespace nn.olsc.srv
{
    internal static class PathInfo
    {
        public const string Prefix = "<";
        public const string Postfix = ">";
        public const string Root = @"nn/olsc";
        public const string Path = Prefix + Root + @"/sfdl/olsc_IOlscService.sfdl.h" + Postfix;
        public const string InternalTypesPath = Prefix + Root + @"/srv/olsc_InternalTypes.h" + Postfix;
    }

    [CppRefPath(PathInfo.InternalTypesPath)]
    [ExternalStruct(128, 8)]
    public struct SaveDataArchiveInfo
    {
    }

    [CppRefPath(PathInfo.InternalTypesPath)]
    [ExternalStruct(16, 8)]
    public struct SeriesInfo
    {
    }

    [CppRefPath(PathInfo.Path)]
    public interface IOlscServiceBase : IServiceObject
    {
        [MethodId(0)]
        Result GetTransferTaskListController(Out<ITransferTaskListController> outValue);

        [MethodId(1)]
        Result GetRemoteStorageController(Out<IRemoteStorageController> outValue);

        [MethodId(2)]
        Result GetDaemonController(Out<IDaemonController> outValue);

        // エラー情報用
        [MethodId(100)]
        Result ListTransferTaskErrorInfo([BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<TransferTaskErrorInfo> outValue, Out<Int32> outCount, Int32 offset);

        [MethodId(101)]
        Result GetTransferTaskErrorInfoCount(Out<Int32> outValue);

        [MethodId(102)]
        Result RemoveTransferTaskErrorInfo(nn.account.Uid uid, ApplicationId appId);

        // ポリシー関連
        [MethodId(200)]
        Result GetDataTransferPolicy(Out<DataTransferPolicy> outValue, ApplicationId appId);

        [MethodId(201)]
        Result DeleteDataTransferPolicy(ApplicationId appId);

        [MethodId(202)]
        Result RequestUpdateDataTransferPolicyAsync(Out<IAsyncResult> outValue, ApplicationId appId);

        // 自動 UL 関連
        [MethodId(300)]
        Result RunAutonomyUploadTransferTaskRegistration(nn.account.Uid uid);

        // デバッグ用
        [MethodId(900)]
        Result DeleteAllTransferTask();

//        [MethodId(901)]
//        Result RegisterTransferTask(Out<TransferTaskId> outValue, nn.account.Uid uid, ApplicationId appId, TransferTaskKind kind);
        [MethodId(902)]
        Result DeleteAllSeriesInfo(nn.account.Uid uid);

        [MethodId(903)]
        Result DeleteAllSdaInfoCache(nn.account.Uid uid);

        [MethodId(904)]
        Result DeleteAllApplicationSetting(nn.account.Uid uid);

        [MethodId(905)]
        Result DeleteAllTransferTaskErrorInfo();

        [MethodId(906)]
        Result RegisterTransferTaskErrorInfo(TransferTaskErrorInfo errorInfo);

        [MethodId(907)]
        Result AddSaveDataArchiveInfoCache(nn.account.Uid uid, SaveDataArchiveInfo sda);

        [MethodId(908)]
        Result DeleteSeriesInfo(nn.account.Uid uid, ApplicationId appId);

        [MethodId(909)]
        Result GetSeriesInfo(Out<SeriesInfo> outValue, nn.account.Uid uid, ApplicationId appId);
    }

    public interface IOlscServiceForSystemService : IOlscServiceBase
    {
    }

    [CppRefPath(PathInfo.Path)]
    public interface IStopperObject : IServiceObject
    {
    }

    [CppRefPath(PathInfo.Path)]
    public interface INativeHandleHolder : IServiceObject
    {
        [MethodId(0)]
        Result GetNativeHandle(Out<NativeHandle> outValue);
    }

    [CppRefPath(PathInfo.Path)]
    public interface ITransferTaskListController : IServiceObject
    {
        [MethodId(0)]
        Result GetTransferTaskCount(Out<UInt32> outValue);

        [MethodId(1)]
        Result GetTransferTaskInfo(Out<TransferTaskInfo> outValue, TransferTaskId id);

        [MethodId(2)]
        Result ListTransferTaskInfo([BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<TransferTaskInfo> outValue, Out<Int32> outCount, Int32 offset);

        [MethodId(3)]
        Result DeleteTransferTask(TransferTaskId id);

        [MethodId(4)]
        Result RaiseTransferTaskPriority(TransferTaskId id);

        [MethodId(5)]
        Result GetTransferTaskEndEventNativeHandleHolder(Out<INativeHandleHolder> outValue);

        [MethodId(6)]
        Result GetTransferTaskProgress(Out<TransferTaskProgressForIpc> outValue, TransferTaskId id);

        [MethodId(7)]
        Result GetTransferTaskLastResult(TransferTaskId id);

        [MethodId(8)]
        Result StopNextTransferTaskExecution(Out<IStopperObject> outValue);

        [MethodId(9)]
        Result GetTransferTaskStartEventNativeHandleHolder(Out<INativeHandleHolder> outValue);

        [MethodId(10)]
        Result SuspendTransferTask(TransferTaskId id);
    }

    [CppRefPath(PathInfo.Path)]
    public interface IRemoteStorageController : IServiceObject
    {
        [MethodId(0)]
        Result RegisterUploadSaveDataTransferTask(Out<TransferTaskId> outValue, nn.account.Uid uid, ApplicationId appId);

        [MethodId(1)]
        Result RegisterDownloadSaveDataTransferTask(Out<TransferTaskId> outValue, nn.account.Uid uid, nn.olsc.DataId dataId);

        [MethodId(2)]
        Result ListDataInfo(Out<int32_t> outValue, OutBuffer outBuffer, int32_t count, nn.account.Uid uid, int32_t offset);

        [MethodId(3)]
        Result GetCount(Out<int32_t> outValue, nn.account.Uid uid);

        [MethodId(4)]
        Result GetDataInfo(Out<bool> outValue, Out<DataInfo> outBuffer, nn.account.Uid uid, ApplicationId appId);

        // [MethodId(5)]
        // Result RequestUpdateDataInfoCache(nn.account.Uid uid);

        [MethodId(6)]
        Result ClearDataInfoCache(nn.account.Uid uid);

        [MethodId(7)]
        Result RequestUpdateDataInfoCacheAsync(Out<IAsyncResult> outValue, nn.account.Uid uid);

        [MethodId(8)]
        Result RequestUpdateDataInfoCacheOfSpecifiedApplicationAsync(Out<IAsyncResult> outValue, nn.account.Uid uid, ApplicationId appId);

        [MethodId(9)]
        Result DeleteDataInfo(nn.account.Uid uid, nn.olsc.DataId dataId);

        [MethodId(10)]
        Result GetDataNewness(Out<DataNewness> outValue, nn.account.Uid uid, nn.olsc.DataId dataId);

        [MethodId(11)]
        Result RequestDeleteData(Out<IAsyncResult> outValue, nn.account.Uid uid, nn.olsc.DataId dataId);
    }

    [CppRefPath(PathInfo.Path)]
    public interface IDaemonController : IServiceObject
    {
        [MethodId(0)]
        Result GetApplicationAutoUploadSetting(Out<bool> outValue, nn.account.Uid uid, ApplicationId appId);

        [MethodId(1)]
        Result SetApplicationAutoUploadSetting(nn.account.Uid uid, ApplicationId appId, bool isEnabled);

        [MethodId(2)]
        Result GetGlobalAutoUploadSetting(Out<bool> outValue, nn.account.Uid uid);
        [MethodId(3)]
        Result SetGlobalAutoUploadSetting(nn.account.Uid uid, bool isEnabled);

        [MethodId(10)]
        Result CreateForbiddenSaveDataInidication(Out<IForbiddenSaveDataIndication> pOut, ApplicationId appId);
    }

    [CppRefPath(PathInfo.Path)]
    public interface IAsyncResult : IServiceObject
    {
        [MethodId(0)]
        Result GetResult();

        [MethodId(1)]
        Result Cancel();

        [MethodId(2)]
        Result IsAvailable(Out<bool> outValue);

        [MethodId(3)]
        Result GetSystemEvent(Out<NativeHandle> outValue);
    }

    [CppRefPath(PathInfo.Path)]
    public interface IForbiddenSaveDataIndication : IServiceObject
    {
        [MethodId(0)]
        Result Update([NotEmpty] InArray<ApplicationId> appIds);
    }
}
