﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;

namespace nn.nifm
{
    [CppRefPath(@"<nn/nifm/nifm_TypesClientManagement.h>")]
    [ExternalStruct(4, 4)]
    public struct ClientId
    {
    }
}

namespace nn.time
{
    [CppRefPath(@"<nn/time/time_Types.h>")]
    [ExternalStruct(8, 8)]
    public struct PosixTime
    {
    }
}

namespace nn.ntc.detail.service
{
    public interface IEnsureNetworkClockAvailabilityService : IServiceObject
    {
        [MethodId(0)]
        Result StartTask();

        [MethodId(1)]
        Result GetSystemEventReadableHandle(Out<NativeHandle> outEvent);

        [MethodId(2)]
        Result GetResult();

        [MethodId(3)]
        Result Cancel();

        [MethodId(4)]
        Result IsProcessing(Out<bool> outIsProcessing);

        [MethodId(5)]
        Result GetServerTime(Out<nn.time.PosixTime> outServerTime);
    }

    public interface IStaticService : IServiceObject
    {
        [MethodId(0)]
        Result GetEnsureNetworkClockAvailabilityService(
            Out<IEnsureNetworkClockAvailabilityService> outAsyncRequestService,
            int32_t ensureNetworkClockAvailabilityMode,
            nn.nifm.ClientId clientId
            );

        [MethodId(100)]
        Result SuspendAutonomicTimeCorrection();

        [MethodId(101)]
        Result ResumeAutonomicTimeCorrection();

    }
}
