﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nn/ns/ns_Result.h>
#include <nn/ns/srv/ns_PushNotificationDisptcher.h>
#include <nn/ns/ns_SystemUpdateApi.h>
#include <nn/ns/ns_SystemUpdateSystemApi.h>

#include <nn/npns.h>
#include <nn/npns/npns_ApiSystem.h>

#include "ns_SystemUpdateUtil.h"
#include "ns_SystemUpdateTopic.h"

namespace nn { namespace ns { namespace srv {

    Result ProcessNetworkUpdateNotification(const NotificationInfo& notificationInfo) NN_NOEXCEPT
    {
        NN_PN_TRACE("Process nup notification\n");
        NN_PN_TRACE("  SystemUpdateId: %016llx, version: %d\n",
            notificationInfo.nupInfo.titleId, notificationInfo.nupInfo.titleVersion);

        auto systemUpdateMetaKey = ncm::ContentMetaKey::Make(notificationInfo.nupInfo.titleId, notificationInfo.nupInfo.titleVersion, ncm::ContentMetaType::SystemUpdate);
        NN_RESULT_DO(nn::ns::NotifyBackgroundNetworkUpdate(systemUpdateMetaKey));

        NN_RESULT_SUCCESS;
    }

    Result ProcessRequiredVersionNotification(VulnerabilityManager* systemVersionManager, const NotificationInfo& info) NN_NOEXCEPT
    {
        NN_PN_TRACE("Process required version notification.\n");
        NN_PN_TRACE("  SystemUpdateId: %016llx, version: %d\n", info.nupInfo.requiredTitleId, info.nupInfo.requiredVersion);
        NN_RESULT_DO(systemVersionManager->UpdateSafeSystemVersionInfo({ info.nupInfo.requiredTitleId }, info.nupInfo.requiredVersion));
        NN_RESULT_SUCCESS;
    }
}}}
