﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/ns_Result.h>
#include <nn/ns/detail/ns_Log.h>
#include <nn/nim/nim_LocalCommunicationReceiveApplicationTaskInfo.h>
#include <nn/nim/nim_NetworkInstallManagerApi.h>
#include <nn/util/util_TypedStorage.h>
#include "ns_ReceiveApplicationTask.h"

namespace nn { namespace ns { namespace srv {

    ReceiveApplicationTask::ReceiveApplicationTask(ncm::ApplicationId appId) NN_NOEXCEPT
    {
        m_IsValid = nim::ListApplicationLocalCommunicationReceiveApplicationTask(&m_Id, 1, appId) > 0;
    }

    Result ReceiveApplicationTask::GetProgress(ReceiveApplicationProgress* outValue) NN_NOEXCEPT
    {
        nim::LocalCommunicationReceiveApplicationTaskInfo info;
        NN_RESULT_DO(nim::GetLocalCommunicationReceiveApplicationTaskInfo(&info, m_Id));

        ReceiveApplicationProgress progress = { info.progress.installedSize, info.progress.totalSize };

        *outValue = progress;

        NN_RESULT_SUCCESS;
    }

    Result ReceiveApplicationTask::IsDownloaded(bool* outValue) NN_NOEXCEPT
    {
        nim::LocalCommunicationReceiveApplicationTaskInfo info;
        NN_RESULT_DO(nim::GetLocalCommunicationReceiveApplicationTaskInfo(&info, m_Id));

        *outValue = (info.progress.state == ncm::InstallProgressState::Downloaded);
        NN_RESULT_SUCCESS;
    }

    Result ReceiveApplicationTask::Commit() NN_NOEXCEPT
    {
        NN_RESULT_DO(nim::CommitLocalCommunicationReceiveApplicationTask(m_Id));
        NN_RESULT_SUCCESS;
    }

    Result ReceiveApplicationTask::Destroy() NN_NOEXCEPT
    {

        return nim::DestroyLocalCommunicationReceiveApplicationTask(m_Id);
    }

    Result ReceiveApplicationTask::CalculateRequiredSize(int64_t* outValue) NN_NOEXCEPT
    {
        return nim::CalculateLocalCommunicationReceiveApplicationTaskRequiredSize(outValue, m_Id);
    }

    Result ReceiveApplicationTask::GetErrorContext(err::ErrorContext* outValue) NN_NOEXCEPT
    {
        NN_RESULT_DO(nim::GetLocalCommunicationReceiveApplicationTaskErrorContext(outValue, m_Id));
        NN_RESULT_SUCCESS;
    }

    Result ReceiveApplicationTask::ListKey(int* outCount, ncm::StorageContentMetaKey outList[], int count, int offset) NN_NOEXCEPT
    {
        NN_RESULT_DO(nim::ListLocalCommunicationReceiveApplicationTaskContentMeta(outCount, outList, count, offset, m_Id));
        NN_RESULT_SUCCESS;
    }
}}}
