﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/ns_Result.h>
#include <nn/ns/detail/ns_IApplicationManagerInterface.sfdl.h>
#include <nn/ns/srv/ns_GameCardRegistrationManager.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/impl/sf_StaticOneAllocator.h>

#include "ns_AsyncImpl.h"

namespace nn { namespace ns { namespace srv {
    namespace {
        typedef sf::ObjectFactory<sf::impl::StaticOneAllocationPolicy> StaticOneFactory;
    }

    Result GameCardRegistrationManager::RequestCheckGameCardRegistration(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncResult>> outAsync, ncm::ApplicationId appId) NN_NOEXCEPT
    {
        auto emplacedRef = StaticOneFactory::CreateSharedEmplaced<ns::detail::IAsyncResult, AsyncCheckGameCardRegistrationImpl>();
        NN_RESULT_THROW_UNLESS(emplacedRef, ResultOutOfMaxRunningTask());
        NN_RESULT_DO(emplacedRef.GetImpl().Initialize(appId, m_GameCardManager));
        NN_RESULT_DO(emplacedRef.GetImpl().Run());

        *outHandle = sf::NativeHandle(emplacedRef.GetImpl().GetEvent().GetReadableHandle(), false);
        *outAsync = emplacedRef;

        NN_RESULT_SUCCESS;
    }

    Result GameCardRegistrationManager::RequestGameCardRegistrationGoldPoint(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncValue>> outAsync, const account::Uid& uid, ncm::ApplicationId appId) NN_NOEXCEPT
    {
        auto emplacedRef = StaticOneFactory::CreateSharedEmplaced<ns::detail::IAsyncValue, AsyncGameCardRegistrationGoldPointImpl>();
        NN_RESULT_THROW_UNLESS(emplacedRef, ResultOutOfMaxRunningTask());
        NN_RESULT_DO(emplacedRef.GetImpl().Initialize(uid, appId, m_GameCardManager));
        NN_RESULT_DO(emplacedRef.GetImpl().Run());

        *outHandle = sf::NativeHandle(emplacedRef.GetImpl().GetEvent().GetReadableHandle(), false);
        *outAsync = emplacedRef;

        NN_RESULT_SUCCESS;
    }

    Result GameCardRegistrationManager::RequestRegisterGameCard(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncResult>> outAsync, const account::Uid& uid, ncm::ApplicationId appId, int goldPoint) NN_NOEXCEPT
    {
        auto emplacedRef = StaticOneFactory::CreateSharedEmplaced<ns::detail::IAsyncResult, AsyncRegisterGameCardImpl>();
        NN_RESULT_THROW_UNLESS(emplacedRef, ResultOutOfMaxRunningTask());
        NN_RESULT_DO(emplacedRef.GetImpl().Initialize(uid, appId, goldPoint, m_GameCardManager));
        NN_RESULT_DO(emplacedRef.GetImpl().Run());

        *outHandle = sf::NativeHandle(emplacedRef.GetImpl().GetEvent().GetReadableHandle(), false);
        *outAsync = emplacedRef;

        NN_RESULT_SUCCESS;
    }
}}}
