﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/ns/srv/ns_ApplicationRecordDatabase.h>
#include <nn/ns/srv/ns_IntegratedContentManager.h>
#include <nn/ns/srv/ns_LockedBufferManager.h>

namespace nn { namespace ns { namespace srv {

Result CleanupOrphanContents(ncm::StorageId storageId) NN_NOEXCEPT;
Result CleanupAllNetworkInstallTask() NN_NOEXCEPT;
Result CleanupAllApplyDeltaTask() NN_NOEXCEPT;
Result CleanupApplyDeltaTask(ncm::StorageId storageId) NN_NOEXCEPT;
Result CleanupFragments(ncm::StorageId storageId) NN_NOEXCEPT;
Result CleanupAllPlaceHolderAndFragmentsIfNoTask(IntegratedContentManager* integrated) NN_NOEXCEPT;
Result CleanupCacheStorage(ApplicationRecordDatabase* recordDb, IntegratedContentManager* integrated, LockedBufferManager* lockedBufferManager, bool isCleanupOrphanCacheStorageEnabledForDebug) NN_NOEXCEPT;
}}}
