﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/srv/ns_ApplicationKeyValueCache.h>

namespace nn { namespace ns { namespace srv {

ncm::ApplicationId ApplicationControlKey::GetId() const
{
    ncm::ApplicationId id;
    std::memcpy(&id, data, sizeof(id));
    return id;
}

uint32_t ApplicationControlKey::GetVersion() const
{
    uint32_t version;
    std::memcpy(&version, &data[sizeof(ncm::ApplicationId)], sizeof(version));
    return version;
}

settings::LanguageCode ApplicationControlKey::GetLanguageCode() const
{
    settings::LanguageCode languageCode;
    std::memcpy(&languageCode, &data[sizeof(ncm::ApplicationId) + sizeof(uint32_t)], sizeof(languageCode));
    return languageCode;
}

bool ApplicationControlKey::operator == (const ApplicationControlKey& key) const
{
    return std::memcmp(data, key.data, sizeof(data)) == 0;
}

ApplicationControlKey ApplicationControlKey::Make(ncm::ApplicationId id, uint32_t version, settings::LanguageCode languageCode) NN_NOEXCEPT
{
    ApplicationControlKey key = {};
    std::memcpy(key.data, &id, sizeof(id));
    std::memcpy(&key.data[sizeof(id)], &version, sizeof(version));
    std::memcpy(&key.data[sizeof(id) + sizeof(version)], &languageCode, sizeof(languageCode));

    return key;
}

}}}
