﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nsd/detail/nsd_BuiltinBackboneSettings.h>
#include <nn/nsd/nsd_BackboneSettingsTypes.h>

namespace nn { namespace nsd { namespace detail {

    // [注意]
    // BackboneSettings に以下の変更を入れる場合は必ず nsd_Version.h の バージョンをあげてください.
    //  - 必須項目の追加、変更
    //  - 互換性が切れる変更

    namespace
    {
        const BackboneSettings BuiltinBackboneSettingsLp1 =
        {
            { // struct NasServiceSettings
                {"accounts.nintendo.com"}, // NAS request service FQDN
                {"api.accounts.nintendo.com"}, // NAS api service FQDN
                { // Entry entries[NasServiceEntryCountMax];
                    { // struct NasServiceSetting::Entry
                        NasServiceNameOfNxAccount, // struct ServiceName
                        { // struct NasServiceSetting
                            0x6ffd70c434d303c8ULL, // struct NasServiceSetting::clientId
                            {"nintendo://account.nx.sys"} // struct NasServiceSetting::redirectUri
                        }
                    },
                    {
                        NasServiceNameOfNxShop, // struct ServiceName
                        { // struct NasServiceSetting
                            0xe56201e414c97a10ULL, // struct NasServiceSetting::clientId
                            {"nintendo://shop.nx.sys"} // struct NasServiceSetting::redirectUri
                        },
                    },
                    {
                        NasServiceNameOfNxFriends, // struct ServiceName
                        { // struct NasServiceSetting
                            0x57d3dbaa12cb06a9ULL, // struct NasServiceSetting::clientId
                            {"nintendo://friends.nx.sys"} // struct NasServiceSetting::redirectUri
                        },
                    },
                    {
                        NasServiceNameOfNxELicense, // struct ServiceName
                        { // struct NasServiceSetting
                            0x48d6d1f020427ad7ULL, // struct NasServiceSetting::clientId
                            {"nintendo://e-license.nx.sys"} // struct NasServiceSetting::redirectUri
                        }
                    },
                }
            },
            { // FqdnEntry fqdnEntries[FqdnEntryCountMax];
                { // struct FqdnEntry
                    {"e97b8a9d672e4ce4845ec6947cd66ef6-sb.baas.nintendo.com"}, // nx-baas-fqdn-dd1
                    {"e0d67c509fb203858ebcb2fe3f88c2aa.baas.nintendo.com"} // nx-baas-fqdn-lp1
                }
            }
        };

        const BackboneSettings BuiltinBackboneSettingsDd1 =
        {
            { // struct NasServiceSettings
                {"e97b8a9d672e4ce4845ec6947cd66ef6-sb.accounts.nintendo.com"}, // NAS request service FQDN
                {"e97b8a9d672e4ce4845ec6947cd66ef6-sb-api.accounts.nintendo.com"}, // NAS api service FQDN
                { // Entry entries[NasServiceEntryCountMax];
                    { // struct NasServiceSetting::Entry
                        NasServiceNameOfNxAccount, // struct ServiceName
                        { // struct NasServiceSetting
                            0xb266f39b541d814fULL, // struct NasServiceSetting::clientId
                            {"nintendo://account.nx.sys"} // struct NasServiceSetting::redirectUri
                        }
                    },
                    {
                        NasServiceNameOfNxShop, // struct ServiceName
                        { // struct NasServiceSetting
                            0xd263e139a1e5686bULL, // struct NasServiceSetting::clientId
                            {"nintendo://shop.nx.sys"} // struct NasServiceSetting::redirectUri
                        },
                    },
                    {
                        NasServiceNameOfNxFriends, // struct ServiceName
                        { // struct NasServiceSetting
                            0xf1dcad9f24a77539ULL, // struct NasServiceSetting::clientId
                            {"nintendo://friends.nx.sys"} // struct NasServiceSetting::redirectUri
                        },
                    },
                    {
                        NasServiceNameOfNxELicense, // struct ServiceName
                        { // struct NasServiceSetting
                            0x3d8c4fc68f09c4ccULL, // struct NasServiceSetting::clientId
                            {"nintendo://e-license.nx.sys"} // struct NasServiceSetting::redirectUri
                        }
                    },
                }
            },
            { // FqdnEntry fqdnEntries[FqdnEntryCountMax];
                { // struct FqdnEntry
                    {"e0d67c509fb203858ebcb2fe3f88c2aa.baas.nintendo.com"}, // nx-baas-fqdn-lp1
                    {"e97b8a9d672e4ce4845ec6947cd66ef6-sb.baas.nintendo.com"} // nx-baas-fqdn-dd1
                }
            }
        };
    }; // namespace

    const BackboneSettings& GetBuiltinBackboneSettings(const EnvironmentIdentifier& environmentIdentifier) NN_NOEXCEPT
    {
        if(environmentIdentifier == nn::nsd::EnvironmentIdentifierOfProductDevice)
        {
            return BuiltinBackboneSettingsLp1;
        }
        else if(environmentIdentifier == nn::nsd::EnvironmentIdentifierOfNotProductDevice)
        {
            return BuiltinBackboneSettingsDd1;
        }
        else
        {
            NN_ABORT("[NSD] Invalid environmentIdentifier %s", environmentIdentifier );
        }
    }

    const Fqdn& GetDd1NasRequestFqdn() NN_NOEXCEPT
    {
        return BuiltinBackboneSettingsDd1.nasServiceSettings.nasRequestServiceFqdn;
    }

    const Fqdn& GetDd1NasApiFqdn() NN_NOEXCEPT
    {
        return BuiltinBackboneSettingsDd1.nasServiceSettings.nasApiServiceFqdn;
    }

    const Fqdn& GetLp1NasRequestFqdn() NN_NOEXCEPT
    {
        return BuiltinBackboneSettingsLp1.nasServiceSettings.nasRequestServiceFqdn;
    }

    const Fqdn& GetLp1NasApiFqdn() NN_NOEXCEPT
    {
        return BuiltinBackboneSettingsLp1.nasServiceSettings.nasApiServiceFqdn;
    }

}}} // nn::nsd::detail
