﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/nifm_ApiClientManagement.h>
#include <nn/ns/ns_DeviceLinkApi.h>
#include <nn/ns/ns_Result.h>
#include "ns_Initialize.h"

namespace nn { namespace ns {

bool IsAnyApplicationRunning() NN_NOEXCEPT
{
    return GetContentManagementInterface()->IsAnyApplicationRunning();
}

Result RequestLinkDevice(AsyncResult* outValue, const account::Uid& uid) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(nifm::IsAnyInternetRequestAccepted(nifm::GetClientId()), ResultInternetRequestNotAccepted());

    sf::NativeHandle nativeHandle;
    sf::SharedPointer<detail::IAsyncResult> sp;
    NN_RESULT_DO(GetECommerceInterface()->RequestLinkDevice(&nativeHandle, &sp, uid));
    outValue->Initialize(sp, nativeHandle);
    nativeHandle.Detach();

    NN_RESULT_SUCCESS;
}

}}
