﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/ns/ns_Result.h>
#include <nn/ns/ns_ApplicationEntityApi.h>
#include <nn/ns/ns_ApplicationEntitySystemApi.h>

#include "ns_Initialize.h"

namespace nn { namespace ns {
    Result DeleteApplicationEntity(ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->DeleteApplicationEntity(id);
    }

    Result DeleteApplicationCompletely(ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->DeleteApplicationCompletely(id);
    }

    bool IsAnyApplicationEntityRedundant() NN_NOEXCEPT
    {
        bool outValue;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->IsAnyApplicationEntityRedundant(&outValue));

        return outValue;
    }

    Result DeleteRedundantApplicationEntity() NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->DeleteRedundantApplicationEntity();
    }

    bool IsApplicationEntityMovable(ncm::ApplicationId id, ncm::StorageId storage) NN_NOEXCEPT
    {
        bool outValue;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->IsApplicationEntityMovable(&outValue, id, storage));

        return outValue;
    }

    Result MoveApplicationEntity(ncm::ApplicationId id, ncm::StorageId storage) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->MoveApplicationEntity(id, storage);
    }

    bool IsAnyApplicationEntityInstalled(ncm::ApplicationId id) NN_NOEXCEPT
    {
        bool outValue;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->IsAnyApplicationEntityInstalled(&outValue, id));

        return outValue;
    }

    Result DeleteApplicationContentEntity(const ncm::ContentMetaKey& key) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->DeleteApplicationContentEntity(key);
    }

    Result DeleteApplicationContentEntities(ncm::ApplicationId id, ApplicationEntityFlag flags, ncm::StorageId storageId) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->DeleteApplicationContentEntities(id, flags._storage[0], storageId);
    }

    Result CleanupUnrecordedApplicationEntity(ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->CleanupUnrecordedApplicationEntity(id);
    }

    Result CleanupAddOnContentsWithNoRights(ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->CleanupAddOnContentsWithNoRights(id);
    }

    Result DeleteApplicationCompletelyForDebug(ncm::ApplicationId id, ApplicationEntityFlag flags) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->DeleteApplicationCompletelyForDebug(id, flags._storage[0]);
    }

}}
