﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/nifm_ApiClientManagement.h>
#include <nn/ns/ns_ApplicationDownloadApi.h>
#include <nn/ns/ns_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_Types.h>
#include "ns_Initialize.h"

namespace nn { namespace ns {

    Result RequestApplicationUpdateInfo(AsyncApplicationUpdateInfo* outValue, ncm::ApplicationId id) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(nifm::IsAnyInternetRequestAccepted(nifm::GetClientId()), ResultInternetRequestNotAccepted());

        sf::NativeHandle nativeHandle;
        sf::SharedPointer<detail::IAsyncValue> sp;
        NN_RESULT_DO(GetApplicationManagerInterface()->RequestApplicationUpdateInfo(&nativeHandle, &sp, id));
        outValue->Initialize(sp, nativeHandle);
        nativeHandle.Detach();

        NN_RESULT_SUCCESS;
    }

    Result RequestUpdateApplication(AsyncResult* outValue, ncm::ApplicationId id) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(nifm::IsAnyInternetRequestAccepted(nifm::GetClientId()), ResultInternetRequestNotAccepted());

        sf::NativeHandle nativeHandle;
        sf::SharedPointer<detail::IAsyncResult> sp;
        NN_RESULT_DO(GetApplicationManagerInterface()->RequestUpdateApplication2(&nativeHandle, &sp, id));
        outValue->Initialize(sp, nativeHandle);
        nativeHandle.Detach();

        NN_RESULT_SUCCESS;
    }

    Result CancelApplicationDownload(ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->CancelApplicationDownload(id);
    }

    Result ResumeApplicationDownload(ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->ResumeApplicationDownload(id);
    }

    Result CalculateApplicationDownloadRequiredSize(ncm::StorageId* outStorageId, int64_t* outValue, ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->CalculateApplicationDownloadRequiredSize(outStorageId, outValue, id);
    }

    Result CancelApplicationApplyDelta(ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->CancelApplicationApplyDelta(id);
    }

    Result ResumeApplicationApplyDelta(ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->ResumeApplicationApplyDelta(id);
    }

    Result CalculateApplicationApplyDeltaRequiredSize(ncm::StorageId* outStorageId, int64_t* outValue, ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->CalculateApplicationApplyDeltaRequiredSize(outStorageId, outValue, id);
    }

    void ResumeAll() NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->ResumeAll());
    }

    void EnableAutoCommit() NN_NOEXCEPT
    {
        GetDownloadTaskInterface()->EnableAutoCommit();
    }

    void DisableAutoCommit() NN_NOEXCEPT
    {
        GetDownloadTaskInterface()->DisableAutoCommit();
    }

    Result DownloadApplication(ncm::ApplicationId applicationId, ncm::StorageId storageId) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(nifm::IsAnyInternetRequestAccepted(nifm::GetClientId()), ResultInternetRequestNotAccepted());

        return GetApplicationManagerInterface()->DownloadApplication(applicationId, storageId, true);
    }

    Result RequestDownloadApplication(AsyncResult* outValue, ncm::ApplicationId applicationId, ncm::StorageId storageId) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(nifm::IsAnyInternetRequestAccepted(nifm::GetClientId()), ResultInternetRequestNotAccepted());

        sf::NativeHandle nativeHandle;
        sf::SharedPointer<detail::IAsyncResult> sp;
        NN_RESULT_DO(GetApplicationManagerInterface()->RequestDownloadApplication(&nativeHandle, &sp, applicationId, storageId, true));
        outValue->Initialize(sp, nativeHandle);
        nativeHandle.Detach();

        NN_RESULT_SUCCESS;
    }

    Result RequestDownloadAddOnContent(AsyncResult* outValue, ncm::ApplicationId id, ncm::ContentMetaKey* keyList, int count, ncm::StorageId storageId) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(nifm::IsAnyInternetRequestAccepted(nifm::GetClientId()), ResultInternetRequestNotAccepted());

        sf::NativeHandle nativeHandle;
        sf::SharedPointer<detail::IAsyncResult> sp;
        sf::InArray<ncm::ContentMetaKey> list(keyList, count);
        NN_RESULT_DO(GetApplicationManagerInterface()->RequestDownloadAddOnContent(&nativeHandle, &sp, id, list, storageId));
        outValue->Initialize(sp, nativeHandle);
        nativeHandle.Detach();

        NN_RESULT_SUCCESS;
    }
}}

