﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/es.h>
#include <nn/util/util_Optional.h>
#include <nn/nim/srv/nim_HttpConnection.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/nim/nim_EciAccessorDefinition.h>

namespace nn { namespace nim { namespace srv {
    Result GetLatestVersion(util::optional<uint32_t>* outValue, HttpConnection* connection, Bit64 id) NN_NOEXCEPT;
    Result GetLatestContentMetaKey(ncm::ContentMetaKey* out, int* outCount, int maxCount, HttpConnection* connection, Bit64 id) NN_NOEXCEPT;
    Result GetPatchIdOfApplication(ncm::PatchId* outValue, HttpConnection* connection, const ncm::ContentMetaKey& key) NN_NOEXCEPT;
    Result GetAndInstallCommonTicket(HttpConnection* connection, const es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT;
}}}
