﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

namespace nn { namespace nim { namespace srv {
    struct Signature
    {
        Bit32       type;
        Bit8        data[60];
        Bit8        padding[64];
    };

    struct DeviceName
    {
        char    prefix[2];
        char    id[16];
        char    delimiter;
        char    variation;
        char    padding[44];
    };

    struct EciDeviceCertificate
    {
        Signature   signature;
        char        publisher[64];
        Bit32       publicKeyType;
        DeviceName  name;
        Bit32       expirationDate;
        Bit8        publicKey[60];
        Bit8        padding[60];
    };

    NN_STATIC_ASSERT(sizeof(EciDeviceCertificate) == 384);
}}}
