﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_File.h>
#include <nn/kvdb/kvdb_BoundedString.h>
#include <nn/nim/nim_ETag.h>
#include <nn/nim/srv/nim_DeviceContext.h>
#include <nn/nim/srv/nim_HttpConnection.h>
#include <nn/nim/srv/nim_NetworkInstallUrl.h>
#include <nn/nim/srv/nim_ThreadAllocator.h>
#include <nn/sf/sf_Types.h>
#include <nn/util/util_Optional.h>
#include "nim_AsyncImpl.h"

namespace nn { namespace nim { namespace srv {
    class AsyncTemporaryFileBase : public AsyncResultImpl<AsyncTemporaryFileBase>
    {
    public:
        explicit AsyncTemporaryFileBase(ThreadAllocator* threadAllocator) NN_NOEXCEPT;
        ~AsyncTemporaryFileBase() NN_NOEXCEPT;

        Result Initialize(DeviceContext* deviceContext, const Url& url, const char* path, const ETag& eTag) NN_NOEXCEPT;
        Result Execute() NN_NOEXCEPT;
        Result Cancel() NN_NOEXCEPT;
        Result GetSize(sf::Out<int64_t> outValue) NN_NOEXCEPT;
        Result Read(sf::Out<uint64_t> outValue, int64_t offset, sf::OutBuffer outBuffer) NN_NOEXCEPT;
        Result GetETag(nn::sf::Out<nn::nim::ETag> outValue) NN_NOEXCEPT;
        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            m_Connection.GetErrorContext(outValue.GetPointer());
            NN_RESULT_SUCCESS;
        }

    private:
        typedef kvdb::BoundedString<64> Path;

        Bit64 m_DeviceId;
        HttpConnection m_Connection;
        util::optional<fs::FileHandle> m_File;
        Url m_Url;
        Path m_Path;
        bool m_IsDownloaded;
        nn::nim::ETag m_ETag;
    };
}}}
