﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nim/srv/detail/nim_BufferAllocator.h>

namespace nn { namespace nim { namespace srv {

    typedef detail::BufferFlagSet::Flag<0> NetworkSystemUpdateTaskBufferFlag;
    typedef detail::BufferFlagSet::Flag<1> NetworkInstallTaskBufferFlag;
    typedef detail::BufferFlagSet::Flag<2> ApplyDeltaTaskBufferFlag;
    typedef detail::BufferFlagSet::Flag<3> LocalCommunicationSendSystemUpdateTaskBufferFlag;
    typedef detail::BufferFlagSet::Flag<4> LocalCommunicationReceiveSystemUpdateTaskBufferFlag;
    typedef detail::BufferFlagSet::Flag<5> LocalCommunicationSendApplicationTaskBufferFlag;
    typedef detail::BufferFlagSet::Flag<6> LocalCommunicationReceiveApplicationTaskBufferFlag;
    typedef detail::BufferFlagSet::Flag<7> SyncTicketTaskBufferFlag;


    detail::BufferAllocator* GetAsyncTaskBufferAllocator() NN_NOEXCEPT;

}}}
