﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.account
{
    [CppRefPath(@"<nn/account/account_Types.h>")]
    [ExternalStruct(16, 8)]
    public struct Uid { }

    [CppRefPath(@"<nn/account/account_NintendoAccountTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct NintendoAccountId { }
}

namespace nn.es
{
    [CppRefPath(@"<nn/es/es_ELicenseTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct RightsId { }

    [CppRefPath(@"<nn/es/es_ELicenseTypes.h>")]
    [ExternalStruct(16, 1)]
    public struct ELicenseId { }
}

namespace nn.ncm
{
    [CppRefPath(@"<nn/ncm/ncm_ContentMetaId.h>")]
    [ExternalStruct(8, 8)]
    public struct ApplicationId { }

    [CppRefPath(@"<nn/ncm/ncm_SystemContentMetaId.h>")]
    [ExternalStruct(8, 8)]
    public struct SystemDataId { }

    [CppRefPath(@"<nn/ncm/ncm_ContentMetaKey.h>")]
    [ExternalStruct(16, 8)]
    public struct ContentMetaKey { }

    [CppRefPath(@"<nn/ncm/ncm_ContentMetaKey.h>")]
    [ExternalStruct(24, 8)]
    public struct StorageContentMetaKey { }

    [CppRefPath(@"<nn/ncm/ncm_ContentMetaKey.h>")]
    [ExternalStruct(24, 8)]
    public struct ApplicationContentMetaKey { }

    [CppRefPath(@"<nn/ncm/ncm_StorageId.h>")]
    [ExternalStruct(1, 1)]
    public struct StorageId { }

    [CppRefPath(@"<nn/ncm/ncm_ContentStorage.h>")]
    [ExternalStruct(768, 4)]
    [LargeData]
    public struct Path { }

    [CppRefPath(@"<nn/ncm/ncm_InstallTaskOccupiedSize.h>")]
    [ExternalStruct(32, 8)]
    public struct InstallTaskOccupiedSize { }
}

namespace nn.nim
{
    [CppRefPath(@"<nn/nim/nim_SystemUpdateTaskId.h>")]
    [ExternalStruct(16, 8)]
    public struct SystemUpdateTaskId {}

    [CppRefPath(@"<nn/nim/nim_SystemUpdateTaskInfo.h>")]
    [ExternalStruct(64, 8)]
    public struct SystemUpdateTaskInfo{}

    [CppRefPath(@"<nn/nim/nim_NetworkInstallTaskId.h>")]
    [ExternalStruct(16, 1)]
    public struct NetworkInstallTaskId { }

    [CppRefPath(@"<nn/nim/nim_NetworkInstallTaskId.h>")]
    [ExternalStruct(24, 8)]
    public struct NetworkInstallTaskIdAttribute { }

    [CppRefPath(@"<nn/nim/nim_NetworkInstallTaskInfo.h>")]
    [ExternalStruct(64, 8)]
    public struct NetworkInstallTaskInfo { }

    [CppRefPath(@"<nn/nim/nim_BackgroundDownloadStressTaskInfo.h>")]
    [ExternalStruct(16, 8)]
    public struct BackgroundDownloadStressTaskInfo { }

    [CppRefPath(@"<nn/nim/nim_GameCardRegistrationStatus.h>")]
    [ExternalStruct(8, 4)]
    public struct GameCardRegistrationStatus { }

    [CppRefPath(@"<nn/nim/nim_NetworkInstallManagerApi.h>")]
    [ExternalStruct(772, 4)]
    public struct ApplicationControlInfo { }

    [CppRefPath(@"<nn/nim/nim_ApplyDeltaTaskId.h>")]
    [ExternalStruct(16, 1)]
    public struct ApplyDeltaTaskId { }

    [CppRefPath(@"<nn/nim/nim_ApplyDeltaTaskId.h>")]
    [ExternalStruct(48, 8)]
    public struct ApplyDeltaTaskInfo { }

    [CppRefPath(@"<nn/nim/nim_LocalCommunicationReceiveApplicationTaskId.h>")]
    [ExternalStruct(16, 1)]
    public struct LocalCommunicationReceiveApplicationTaskId { }

    [CppRefPath(@"<nn/nim/nim_LocalCommunicationReceiveApplicationTaskInfo.h>")]
    [ExternalStruct(56, 8)]
    public struct LocalCommunicationReceiveApplicationTaskInfo { }

    [CppRefPath(@"<nn/nim/nim_LocalCommunicationSendApplicationTaskId.h>")]
    [ExternalStruct(16, 1)]
    public struct LocalCommunicationSendApplicationTaskId { }

    [CppRefPath(@"<nn/nim/nim_LocalCommunicationSendApplicationTaskInfo.h>")]
    [ExternalStruct(32, 8)]
    public struct LocalCommunicationSendApplicationTaskInfo { }

    [CppRefPath(@"<nn/nim/nim_LocalCommunicationReceiveSystemUpdateTaskId.h>")]
    [ExternalStruct(16, 1)]
    public struct LocalCommunicationReceiveSystemUpdateTaskId { }

    [CppRefPath(@"<nn/nim/nim_LocalCommunicationReceiveSystemUpdateTaskInfo.h>")]
    [ExternalStruct(56, 8)]
    public struct LocalCommunicationReceiveSystemUpdateTaskInfo { }

    [CppRefPath(@"<nn/nim/nim_LocalCommunicationSendSystemUpdateTaskId.h>")]
    [ExternalStruct(16, 1)]
    public struct LocalCommunicationSendSystemUpdateTaskId { }

    [CppRefPath(@"<nn/nim/nim_LocalCommunicationSendSystemUpdateTaskInfo.h>")]
    [ExternalStruct(32, 8)]
    public struct LocalCommunicationSendSystemUpdateTaskInfo { }

    [CppRefPath(@"<nn/nim/nim_DynamicRightsApi.h>")]
    [ExternalStruct(1, 1)]
    public struct ELicenseType { }
}

namespace nn.npns
{
    [CppRefPath(@"<nn/npns/npns_Types.h>")]
    [ExternalStruct(40, 4)]
    public struct NotificationToken {}
}

namespace nn.nim.detail
{
    public interface INetworkInstallManager : IServiceObject
    {
        [MethodId(0)]
        Result CreateSystemUpdateTask(Out<SystemUpdateTaskId> outValue, ncm.ContentMetaKey key, Bit32 config);

        [MethodId(1)]
        Result DestroySystemUpdateTask(SystemUpdateTaskId id);

        [MethodId(2)]
        Result ListSystemUpdateTask(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<SystemUpdateTaskId> outList);

        [MethodId(3)]
        Result RequestSystemUpdateTaskRun(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, SystemUpdateTaskId id);

        [MethodId(4)]
        Result GetSystemUpdateTaskInfo(Out<SystemUpdateTaskInfo> outValue, SystemUpdateTaskId id);

        [MethodId(5)]
        Result CommitSystemUpdateTask(SystemUpdateTaskId id);

        [MethodId(6)]
        Result CreateNetworkInstallTask(Out<NetworkInstallTaskId> outValue, ncm.ApplicationId appId, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ncm.ContentMetaKey> keyList, ncm.StorageId storage, Bit32 config);

        [MethodId(7)]
        Result DestroyNetworkInstallTask(NetworkInstallTaskId id);

        [MethodId(8)]
        Result ListNetworkInstallTask(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<NetworkInstallTaskId> outList);

        [MethodId(9)]
        Result RequestNetworkInstallTaskRun(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, NetworkInstallTaskId id);

        [MethodId(10)]
        Result GetNetworkInstallTaskInfo(Out<NetworkInstallTaskInfo> outValue, NetworkInstallTaskId id);

        [MethodId(11)]
        Result CommitNetworkInstallTask(NetworkInstallTaskId id);

        [MethodId(12)]
        Result RequestLatestSystemUpdateMeta(Out<NativeHandle> outHandle, Out<IAsyncValue> outAsync);

        [MethodId(14)]
        Result ListApplicationNetworkInstallTask(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<NetworkInstallTaskId> outList, ncm.ApplicationId appId);

        [MethodId(15)]
        Result ListNetworkInstallTaskContentMeta(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ncm.StorageContentMetaKey> outList, int offset, NetworkInstallTaskId id);

        [MethodId(16)]
        Result RequestLatestVersion(Out<NativeHandle> outHandle, Out<IAsyncValue> outAsync, ncm.ApplicationId appId);

        [MethodId(17)]
        Result SetNetworkInstallTaskAttribute(NetworkInstallTaskIdAttribute idAttribute);
        // TODO: 下記では sf のビルドができない
        // Result SetNetworkInstallTaskAttribute(NetworkInstallTaskId id, Bit64 attribute);

        [MethodId(18)]
        Result AddNetworkInstallTaskContentMeta([BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ncm.ContentMetaKey> list, NetworkInstallTaskId id);

        [MethodId(19)]
        Result GetDownloadedSystemDataPath([BufferTransferMode(BufferTransferMode.MapAlias)] Out<ncm.Path> outValue, ncm.SystemDataId dataId, SystemUpdateTaskId taskId);

        [MethodId(20)]
        Result CalculateNetworkInstallTaskRequiredSize(Out<int64_t> outValue, NetworkInstallTaskId id);

        [MethodId(21)]
        Result IsExFatDriverIncluded(Out<bool> outValue, SystemUpdateTaskId id);

        [MethodId(22)]
        Result GetBackgroundDownloadStressTaskInfo(Out<BackgroundDownloadStressTaskInfo> outValue);

        [MethodId(23)]
        Result RequestDeviceAuthenticationToken(Out<NativeHandle> outHandle, Out<IAsyncValue> outAsync);

        [MethodId(24)]
        Result RequestGameCardRegistrationStatus(Out<NativeHandle> outHandle, Out<IAsyncValue> outAsync, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ncm.ApplicationId> appIdList, InBuffer token, InBuffer cert);

        [MethodId(25)]
        Result RequestRegisterGameCard(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ncm.ApplicationId> appIdList, InBuffer token, InBuffer cert, GameCardRegistrationStatus status);

        [MethodId(26)]
        Result RequestRegisterNotificationToken(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, nn.npns.NotificationToken notificationToken);

        [MethodId(27)]
        Result RequestDownloadTaskList(Out<NativeHandle> outHandle, Out<IAsyncData> outAsync, ETag eTag);

        [MethodId(28)]
        Result RequestApplicationControl(Out<NativeHandle> outHandle, Out<IAsyncValue> outAsync, ncm.ApplicationId applicationId, uint32_t version);

        [MethodId(29)]
        Result RequestLatestApplicationControl(Out<NativeHandle> outHandle, Out<IAsyncValue> outAsync, ncm.ApplicationId applicationId);

        [MethodId(30)]
        Result RequestVersionList(Out<NativeHandle> outHandle, Out<IAsyncData> outAsync, ETag eTag);

        [MethodId(31)]
        Result CreateApplyDeltaTask(Out<ApplyDeltaTaskId> outValue, ncm.ApplicationId appId, ncm.ContentMetaKey sourceKey, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ncm.ContentMetaKey> keyList, ncm.StorageId storageId);

        [MethodId(32)]
        Result DestroyApplyDeltaTask(ApplyDeltaTaskId id);

        [MethodId(33)]
        Result ListApplicationApplyDeltaTask(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ApplyDeltaTaskId> outList, ncm.ApplicationId appId);

        [MethodId(34)]
        Result RequestApplyDeltaTaskRun(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, ApplyDeltaTaskId id);

        [MethodId(35)]
        Result GetApplyDeltaTaskInfo(Out<ApplyDeltaTaskInfo> outValue, ApplyDeltaTaskId id);

        [MethodId(36)]
        Result ListApplyDeltaTaskContentMeta(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ncm.StorageContentMetaKey> outList, int offset, ApplyDeltaTaskId id);

        [MethodId(37)]
        Result CommitApplyDeltaTask(ApplyDeltaTaskId id);

        [MethodId(38)]
        Result CalculateApplyDeltaTaskRequiredSize(Out<int64_t> outValue, ApplyDeltaTaskId id);

        [MethodId(39)]
        Result PrepareShutdown();

        [MethodId(40)]
        Result ListApplyDeltaTask(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ApplyDeltaTaskId> outList);

        [MethodId(41)]
        Result ClearNotEnoughSpaceStateOfApplyDeltaTask(ApplyDeltaTaskId id);

        [MethodId(42)]
        Result CreateApplyDeltaTaskFromDownloadTask(Out<ApplyDeltaTaskId> outValue, NetworkInstallTaskId id);

        [MethodId(43)]
        Result GetBackgroundApplyDeltaStressTaskInfo(Out<BackgroundDownloadStressTaskInfo> outValue);

        [MethodId(44)]
        Result GetApplyDeltaTaskRequiredStorage(Out<ncm.StorageId> outValue, ApplyDeltaTaskId id);

        [MethodId(45)]
        Result CalculateNetworkInstallTaskContentsSize(Out<int64_t> outValue, NetworkInstallTaskId id, ncm.ContentMetaKey key, ncm.StorageId storageId);

        [MethodId(46)]
        Result PrepareShutdownForSystemUpdate();

        [MethodId(47)]
        Result FindMaxRequiredApplicationVersionOfTask(Out<uint32_t> outValue, NetworkInstallTaskId id);

        [MethodId(48)]
        Result CommitNetworkInstallTaskPartially([BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ncm.StorageContentMetaKey> list, NetworkInstallTaskId id);

        [MethodId(49)]
        Result ListNetworkInstallTaskCommittedContentMeta(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ncm.StorageContentMetaKey> outList, int offset, NetworkInstallTaskId id);

        [MethodId(50)]
        Result ListNetworkInstallTaskNotCommittedContentMeta(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ncm.StorageContentMetaKey> outList, int offset, NetworkInstallTaskId id);

        [MethodId(51)]
        Result FindMaxRequiredSystemVersionOfTask(Out<uint32_t> outValue, NetworkInstallTaskId id);

        [MethodId(52)]
        Result GetNetworkInstallTaskErrorContext([BufferTransferMode(BufferTransferMode.MapAlias)] Out<err.ErrorContext> outValue, NetworkInstallTaskId id);

        [MethodId(53)]
        Result CreateLocalCommunicationReceiveApplicationTask(Out<LocalCommunicationReceiveApplicationTaskId> outValue, uint32_t ipv4, uint16_t port, ncm.ApplicationId appId, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ncm.ContentMetaKey> keyList, ncm.StorageId storage, Bit32 config);

        [MethodId(54)]
        Result DestroyLocalCommunicationReceiveApplicationTask(LocalCommunicationReceiveApplicationTaskId id);

        [MethodId(55)]
        Result ListLocalCommunicationReceiveApplicationTask(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<LocalCommunicationReceiveApplicationTaskId> outList);

        [MethodId(56)]
        Result RequestLocalCommunicationReceiveApplicationTaskRun(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, LocalCommunicationReceiveApplicationTaskId id);

        [MethodId(57)]
        Result GetLocalCommunicationReceiveApplicationTaskInfo(Out<LocalCommunicationReceiveApplicationTaskInfo> outValue, LocalCommunicationReceiveApplicationTaskId id);

        [MethodId(58)]
        Result CommitLocalCommunicationReceiveApplicationTask(LocalCommunicationReceiveApplicationTaskId id);

        [MethodId(59)]
        Result ListLocalCommunicationReceiveApplicationTaskContentMeta(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ncm.StorageContentMetaKey> outList, int offset, LocalCommunicationReceiveApplicationTaskId id);

        [MethodId(60)]
        Result CreateLocalCommunicationSendApplicationTask(Out<LocalCommunicationSendApplicationTaskId> outValue, uint32_t ipv4, uint16_t port, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<ncm.StorageContentMetaKey> keyList, ncm.ApplicationId id);

        [MethodId(61)]
        Result RequestLocalCommunicationSendApplicationTaskRun(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, LocalCommunicationSendApplicationTaskId id);

        [MethodId(62)]
        Result GetLocalCommunicationReceiveApplicationTaskErrorContext([BufferTransferMode(BufferTransferMode.MapAlias)] Out<err.ErrorContext> outValue, LocalCommunicationReceiveApplicationTaskId id);

        [MethodId(63)]
        Result GetLocalCommunicationSendApplicationTaskInfo(Out<LocalCommunicationSendApplicationTaskInfo> outValue, LocalCommunicationSendApplicationTaskId id);

        [MethodId(64)]
        Result DestroyLocalCommunicationSendApplicationTask(LocalCommunicationSendApplicationTaskId id);

        [MethodId(65)]
        Result GetLocalCommunicationSendApplicationTaskErrorContext([BufferTransferMode(BufferTransferMode.MapAlias)] Out<err.ErrorContext> outValue, LocalCommunicationSendApplicationTaskId id);

        [MethodId(66)]
        Result CalculateLocalCommunicationReceiveApplicationTaskRequiredSize(Out<int64_t> outValue, LocalCommunicationReceiveApplicationTaskId id);

        [MethodId(67)]
        Result ListApplicationLocalCommunicationReceiveApplicationTask(Out<int32_t> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<LocalCommunicationReceiveApplicationTaskId> outList, ncm.ApplicationId appId);

        [MethodId(68)]
        Result ListApplicationLocalCommunicationSendApplicationTask(Out<int32_t> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<LocalCommunicationSendApplicationTaskId> outList, ncm.ApplicationId appId);

        [MethodId(69)]
        Result CreateLocalCommunicationReceiveSystemUpdateTask(Out<LocalCommunicationReceiveSystemUpdateTaskId> outValue, uint32_t ipv4, uint16_t port, ncm.ContentMetaKey key, Bit32 config);

        [MethodId(70)]
        Result DestroyLocalCommunicationReceiveSystemUpdateTask(LocalCommunicationReceiveSystemUpdateTaskId id);

        [MethodId(71)]
        Result ListLocalCommunicationReceiveSystemUpdateTask(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<LocalCommunicationReceiveSystemUpdateTaskId> outList);

        [MethodId(72)]
        Result RequestLocalCommunicationReceiveSystemUpdateTaskRun(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, LocalCommunicationReceiveSystemUpdateTaskId id);

        [MethodId(73)]
        Result GetLocalCommunicationReceiveSystemUpdateTaskInfo(Out<LocalCommunicationReceiveSystemUpdateTaskInfo> outValue, LocalCommunicationReceiveSystemUpdateTaskId id);

        [MethodId(74)]
        Result CommitLocalCommunicationReceiveSystemUpdateTask(LocalCommunicationReceiveSystemUpdateTaskId id);

        [MethodId(75)]
        Result GetLocalCommunicationReceiveSystemUpdateTaskErrorContext([BufferTransferMode(BufferTransferMode.MapAlias)] Out<err.ErrorContext> outValue, LocalCommunicationReceiveSystemUpdateTaskId id);

        [MethodId(76)]
        Result CreateLocalCommunicationSendSystemUpdateTask(Out<LocalCommunicationSendSystemUpdateTaskId> outValue, uint32_t ipv4, uint16_t port, ncm.ContentMetaKey key);

        [MethodId(77)]
        Result RequestLocalCommunicationSendSystemUpdateTaskRun(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, LocalCommunicationSendSystemUpdateTaskId id);

        [MethodId(78)]
        Result GetLocalCommunicationSendSystemUpdateTaskInfo(Out<LocalCommunicationSendSystemUpdateTaskInfo> outValue, LocalCommunicationSendSystemUpdateTaskId id);

        [MethodId(79)]
        Result DestroyLocalCommunicationSendSystemUpdateTask(LocalCommunicationSendSystemUpdateTaskId id);

        [MethodId(80)]
        Result GetLocalCommunicationSendSystemUpdateTaskErrorContext([BufferTransferMode(BufferTransferMode.MapAlias)] Out<err.ErrorContext> outValue, LocalCommunicationSendSystemUpdateTaskId id);

        [MethodId(81)]
        Result ListLocalCommunicationSendSystemUpdateTask(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<LocalCommunicationSendSystemUpdateTaskId> outList);

        [MethodId(82)]
        Result GetReceivedSystemDataPath([BufferTransferMode(BufferTransferMode.MapAlias)] Out<ncm.Path> outValue, ncm.SystemDataId dataId, LocalCommunicationReceiveSystemUpdateTaskId taskId);

        [MethodId(83)]
        Result CalculateApplyDeltaTaskOccupiedSize(Out<int64_t> outValue, ApplyDeltaTaskId id, ncm.StorageId storageId);

        [MethodId(84)]
        void ReloadErrorSimulation();

        [MethodId(85)]
        Result ListNetworkInstallTaskContentMetaFromInstallMeta(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ncm.ContentMetaKey> outList, int offset, NetworkInstallTaskId id);

        [MethodId(86)]
        Result ListNetworkInstallTaskOccupiedSize(Out<int> outCount, [BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<ncm.InstallTaskOccupiedSize> outList, int offset, NetworkInstallTaskId id);

        [MethodId(87)]
        Result RequestQueryAvailableELicenses(Out<NativeHandle> outHandle, Out<IAsyncData> outValue, nn.account.Uid uid, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<nn.es.RightsId> rightsIds);

        [MethodId(88)]
        Result RequestAssignELicenses(Out<NativeHandle> outHandle, Out<IAsyncData> outValue, nn.account.Uid uid, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<nn.es.RightsId> rightsIds, nn.nim.ELicenseType licenseType);

        [MethodId(89)]
        Result RequestExtendELicenses(Out<NativeHandle> outHandle, Out<IAsyncData> outValue, nn.account.Uid uid, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<nn.es.ELicenseId> elicenseIds);

        [MethodId(90)]
        Result RequestSyncELicenses(Out<NativeHandle> outHandle, Out<IAsyncResult> outValue, nn.account.NintendoAccountId naId);

        [MethodId(91)]
        Result RequestDownloadETickets(Out<NativeHandle> outHandle, Out<IAsyncResult> outValue, nn.account.Uid uid, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<nn.es.ELicenseId> elicenseIds);

        [MethodId(92)]
        Result RequestQueryRevokeReason(Out<NativeHandle> outHandle, Out<IAsyncValue> outValue, nn.account.NintendoAccountId naId, nn.es.ELicenseId eLicenseId);

        [MethodId(93)]
        Result RequestReportActiveELicenses(Out<NativeHandle> outHandle, Out<IAsyncResult> outValue, nn.account.NintendoAccountId naId, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<nn.es.ELicenseId> elicenseIds);

        [MethodId(94)]
        Result RequestReportActiveELicensesPassively(Out<NativeHandle> outHandle, Out<IAsyncResult> outValue, nn.account.NintendoAccountId naId, [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<nn.es.ELicenseId> elicenseIds);

        [MethodId(95)]
        Result RequestRegisterDynamicRightsNotificationToken(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, nn.npns.NotificationToken notificationToken);

        [MethodId(96)]
        Result RequestAssignAllDeviceLinkedELicenses(Out<NativeHandle> outHandle, Out<IAsyncData> outValue);
    }
}
