﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/nifm_TemporaryNetworkProfile.h>

#include <nn/nifm/detail/nifm_CommonDetail.h>
#include <nn/nifm/detail/nifm_TemporaryNetworkProfileClient.h>

#include <new>


namespace nn
{
namespace nifm
{

TemporaryNetworkProfile::TemporaryNetworkProfile(const NetworkProfileData& profileData) NN_NOEXCEPT
{
    NN_STATIC_ASSERT(sizeof(Storage) >= sizeof(detail::TemporaryNetworkProfileClient));
    NN_STATIC_ASSERT(NN_ALIGNOF(Storage) % NN_ALIGNOF(detail::TemporaryNetworkProfileClient) == 0);

    new(&m_Storage.storage) detail::TemporaryNetworkProfileClient(profileData);
}

TemporaryNetworkProfile::~TemporaryNetworkProfile() NN_NOEXCEPT
{
    reinterpret_cast<detail::TemporaryNetworkProfileClient*>(&m_Storage)->~TemporaryNetworkProfileClient();
}

const nn::util::Uuid& TemporaryNetworkProfile::GetId() const NN_NOEXCEPT
{
    return reinterpret_cast<const detail::TemporaryNetworkProfileClient*>(&m_Storage)->GetId();
}

Result TemporaryNetworkProfile::Update(const NetworkProfileData& profileData) NN_NOEXCEPT
{
    return reinterpret_cast<detail::TemporaryNetworkProfileClient*>(&m_Storage)->Update(profileData);
}

NetworkProfileHandle TemporaryNetworkProfile::GetHandle() NN_NOEXCEPT
{
    NetworkProfileHandle handle = { &m_Storage };

    return handle;
}

}
}
