﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/nifm_ApiTelemetry.h>

#include <nn/nifm/detail/service/nifm_INifmService.sfdl.h>

namespace nn
{
namespace nifm
{
namespace detail
{
nn::Result GetGeneralServicePointer(nn::sf::SharedPointer<detail::IGeneralService>* ppGeneralService) NN_NOEXCEPT;
}

void BindTelemetryInfoEvent(nn::os::SystemEventType* pEventType, nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pEventType);

    nn::sf::SharedPointer<detail::IGeneralService> pGeneralService;
    NN_ABORT_UNLESS_RESULT_SUCCESS(GetGeneralServicePointer(&pGeneralService));

    nn::sf::NativeHandle systemEventInternalReadableHandle;
    NN_ABORT_UNLESS_RESULT_SUCCESS(pGeneralService->GetTelemetorySystemEventReadableHandle(&systemEventInternalReadableHandle));

    nn::os::AttachReadableHandleToSystemEvent(pEventType, systemEventInternalReadableHandle.GetOsHandle(), systemEventInternalReadableHandle.IsManaged(), clearMode);
    systemEventInternalReadableHandle.Detach();
}

void GetTelemetoryInfo(TelemetryInfo *pOutTelemetryInfo) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutTelemetryInfo);

    nn::sf::SharedPointer<detail::IGeneralService> pGeneralService;
    NN_ABORT_UNLESS_RESULT_SUCCESS(GetGeneralServicePointer(&pGeneralService));

    NN_ABORT_UNLESS_RESULT_SUCCESS(pGeneralService->GetTelemetryInfo(pOutTelemetryInfo));
}

}
}

