﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/nifm_ApiRequest.h>
#include <nn/nifm/nifm_ApiRequestPrivate.h>

#include <nn/nifm/detail/nifm_CommonDetail.h>
#include <nn/nifm/detail/nifm_RequestClient.h>


namespace nn
{
namespace nifm
{

nn::Result SetRequestRequirementPreset(RequestHandle handle, RequirementPreset requirementPreset) NN_NOEXCEPT
{
    NN_SDK_ASSERT(handle._value != nullptr, "handle is invalid.\n");

    NN_RESULT_THROW(reinterpret_cast<detail::RequestClient*>(handle._value)->SetRequirementPreset(requirementPreset));
}

nn::Result SetRequestRequirementBySubmitId(RequestHandle handle, uint32_t submitId) NN_NOEXCEPT
{
    NN_SDK_ASSERT(handle._value != nullptr, "handle is invalid.\n");

    NN_RESULT_THROW(reinterpret_cast<detail::RequestClient*>(handle._value)->SetRequirementBySubmitId(submitId));
}

nn::Result SetRequestPriority(RequestHandle handle, uint8_t priority) NN_NOEXCEPT
{
    NN_SDK_ASSERT(handle._value != nullptr, "handle is invalid.\n");

    NN_SDK_REQUIRES(priority >= UserRequestPriorityTop);
    NN_SDK_REQUIRES(priority <= UserRequestPriorityBottom);

    NN_RESULT_THROW(reinterpret_cast<detail::RequestClient*>(handle._value)->SetPriority(priority));
}

nn::Result SetRequestRawPriority(RequestHandle handle, uint8_t rawPriority) NN_NOEXCEPT
{
    NN_SDK_ASSERT(handle._value != nullptr, "handle is invalid.\n");

    NN_RESULT_THROW(reinterpret_cast<detail::RequestClient*>(handle._value)->SetRawPriority(rawPriority));
}


nn::Result SetRequestNetworkProfileId(RequestHandle handle, const nn::util::Uuid& id) NN_NOEXCEPT
{
    NN_SDK_ASSERT(handle._value != nullptr, "handle is invalid.\n");

    NN_RESULT_THROW(reinterpret_cast<detail::RequestClient*>(handle._value)->SetNetworkProfileId(id));
}

nn::Result SetRequestRejectable(RequestHandle handle, bool isRejectable) NN_NOEXCEPT
{
    NN_SDK_ASSERT(handle._value != nullptr, "handle is invalid.\n");

    NN_RESULT_THROW(reinterpret_cast<detail::RequestClient*>(handle._value)->SetRejectable(isRejectable));
}

nn::Result SetRequestConnectionConfirmationOption(RequestHandle handle, ConnectionConfirmationOption connectionConfirmationOption) NN_NOEXCEPT
{
    NN_SDK_ASSERT(handle._value != nullptr, "handle is invalid.\n");

    NN_RESULT_THROW(reinterpret_cast<detail::RequestClient*>(handle._value)->SetConnectionConfirmationOption(connectionConfirmationOption));
}

nn::Result SetRequestPersistent(RequestHandle handle, bool isPersistent) NN_NOEXCEPT
{
    NN_SDK_ASSERT(handle._value != nullptr, "handle is invalid.\n");

    NN_RESULT_THROW(reinterpret_cast<detail::RequestClient*>(handle._value)->SetPersistent(isPersistent));
}

nn::Result SetRequestInstant(RequestHandle handle, bool isInstant) NN_NOEXCEPT
{
    NN_SDK_ASSERT(handle._value != nullptr, "handle is invalid.\n");

    NN_RESULT_THROW(reinterpret_cast<detail::RequestClient*>(handle._value)->SetInstant(isInstant));
}

nn::Result SetRequestSustainable(RequestHandle handle, bool isSustainable) NN_NOEXCEPT
{
    NN_SDK_ASSERT(handle._value != nullptr, "handle is invalid.\n");

    NN_RESULT_THROW(reinterpret_cast<detail::RequestClient*>(handle._value)->SetSustainable(isSustainable));
}

nn::Result SetRequestGreedy(RequestHandle handle, bool isGreedy) NN_NOEXCEPT
{
    NN_SDK_ASSERT(handle._value != nullptr, "handle is invalid.\n");

    NN_RESULT_THROW(reinterpret_cast<detail::RequestClient*>(handle._value)->SetGreedy(isGreedy));
}

nn::Result SetRequestSharable(RequestHandle handle, bool isSharable) NN_NOEXCEPT
{
    NN_SDK_ASSERT(handle._value != nullptr, "handle is invalid.\n");

    NN_RESULT_THROW(reinterpret_cast<detail::RequestClient*>(handle._value)->SetSharable(isSharable));
}

nn::Result SetRequestKeptInSleep(RequestHandle handle, bool isKeptInSleep) NN_NOEXCEPT
{
    NN_SDK_ASSERT(handle._value != nullptr, "handle is invalid.\n");

    NN_RESULT_THROW(reinterpret_cast<detail::RequestClient*>(handle._value)->SetKeptInSleep(isKeptInSleep));
}

nn::Result RegisterRequestSocketDescriptor(RequestHandle handle, int socketDescriptor) NN_NOEXCEPT
{
    NN_SDK_ASSERT(handle._value != nullptr, "handle is invalid.\n");

    NN_RESULT_THROW(reinterpret_cast<detail::RequestClient*>(handle._value)->RegisterSocketDescriptor(socketDescriptor));
}

nn::Result UnregisterRequestSocketDescriptor(RequestHandle handle) NN_NOEXCEPT
{
    NN_SDK_ASSERT(handle._value != nullptr, "handle is invalid.\n");

    NN_RESULT_THROW(reinterpret_cast<detail::RequestClient*>(handle._value)->UnregisterSocketDescriptor(-1));
}

// for Test

nn::Result GetRequestAdditionalInfo(AdditionalInfo* pOutAdditionalInfo, uint32_t* pOutRevision, RequestHandle handle) NN_NOEXCEPT
{
    NN_SDK_ASSERT(handle._value != nullptr, "handle is invalid.\n");

    NN_RESULT_THROW(reinterpret_cast<detail::RequestClient*>(handle._value)->GetAdditionalInfo(pOutAdditionalInfo, pOutRevision));
}

detail::RequestClient* GetRequestClientPointer(RequestHandle handle) NN_NOEXCEPT
{
    return reinterpret_cast<detail::RequestClient*>(handle._value);
}

}
}
