﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/nifm_ApiEthernetCommunicationControl.h>

#include <nn/nifm/detail/nifm_CommonDetail.h>
#include <nn/nifm/detail/util/nifm_SfUtility.h>


namespace nn
{
namespace nifm
{

namespace detail
{
    nn::Result GetGeneralServicePointer(nn::sf::SharedPointer<detail::IGeneralService>* ppGeneralService) NN_NOEXCEPT;
}

void SetEthernetCommunicationEnabled(bool isEnabled) NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::IGeneralService> pGeneralService;
    nn::Result result;

    result = detail::GetGeneralServicePointer(&pGeneralService);
    NN_SDK_ASSERT(result.IsSuccess(), "The nifm library must be Initialized.\n");
    if (result.IsFailure())
    {
        return;
    }

    result = pGeneralService->SetEthernetCommunicationEnabled(isEnabled);

    NN_UNUSED(result);
    NN_SDK_ASSERT(result.IsSuccess());
}

bool IsEthernetCommunicationEnabled() NN_NOEXCEPT
{
    // TODO: ポーリング対策として SharedMemory に置く？

    nn::sf::SharedPointer<detail::IGeneralService> pGeneralService;
    nn::Result result;

    result = detail::GetGeneralServicePointer(&pGeneralService);
    NN_SDK_ASSERT(result.IsSuccess(), "The nifm library must be Initialized.\n");
    if (result.IsFailure())
    {
        return false;
    }

    bool isEnabled;
    result = pGeneralService->IsEthernetCommunicationEnabled(&isEnabled);

    NN_SDK_ASSERT(result.IsSuccess());

    return result.IsSuccess() ? isEnabled : false;
}

}
}

