﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/detail/util/nifm_SfUtility.h>
#include <nn/nifm/detail/nifm_TypesDetail.h>

#include <nn/util/util_StringUtil.h>

namespace nn
{
namespace nifm
{
namespace detail
{

// TODO:TORIAEZU
#if ( defined(NN_BUILD_CONFIG_COMPILER_CLANG) || defined(NN_BUILD_CONFIG_COMPILER_VC) )
NN_STATIC_ASSERT(std::is_trivially_copyable<nn::util::Uuid>::value);
NN_STATIC_ASSERT(std::is_trivially_copyable<Ssid>::value);
NN_STATIC_ASSERT(std::is_trivially_copyable<SharedKey>::value);
NN_STATIC_ASSERT(std::is_trivially_copyable<IpSettingData>::value);
NN_STATIC_ASSERT(std::is_trivially_copyable<MacAddress>::value);
#endif

void ConvertNetworkProfileBasicInfoToSfFromNifm(sf::NetworkProfileBasicInfo* pOutInfo, const NetworkProfileBasicInfo& info) NN_NOEXCEPT
{
    NN_DETAIL_NIFM_ASSERT_NOT_MEMORY_OVERLAP(pOutInfo, sizeof(*pOutInfo), &info, sizeof(info));

    pOutInfo->id = info.id;
    util::Strlcpy(reinterpret_cast<char*>(pOutInfo->name), info.name, NetworkProfileBasicInfo::NameSize);
    pOutInfo->networkProfileType = static_cast<Bit8>(info.networkProfileType);
    pOutInfo->networkInterfaceType = static_cast<Bit8>(info.networkInterfaceType);
    pOutInfo->ssid = info.ssid;
    pOutInfo->authentication = static_cast<Bit8>(info.authentication);
    pOutInfo->encryption = static_cast<Bit8>(info.encryption);
}

void ConvertNetworkProfileBasicInfoToNifmFromSf(NetworkProfileBasicInfo* pOutInfo, const sf::NetworkProfileBasicInfo& info) NN_NOEXCEPT
{
    NN_DETAIL_NIFM_ASSERT_NOT_MEMORY_OVERLAP(pOutInfo, sizeof(*pOutInfo), &info, sizeof(info));

    pOutInfo->id = info.id;
    util::Strlcpy(pOutInfo->name, reinterpret_cast<const char*>(info.name), NetworkProfileBasicInfo::NameSize);
    pOutInfo->networkProfileType = static_cast<NetworkProfileType>(info.networkProfileType);
    pOutInfo->networkInterfaceType = static_cast<NetworkInterfaceType>(info.networkInterfaceType);
    pOutInfo->ssid = info.ssid;
    pOutInfo->authentication = static_cast<Authentication>(info.authentication);
    pOutInfo->encryption = static_cast<Encryption>(info.encryption);
}

void ConvertNetworkProfileDataToSfFromNifm( sf::NetworkProfileData* pOutProfile, const NetworkProfileData& profile ) NN_NOEXCEPT
{
    NN_DETAIL_NIFM_ASSERT_NOT_MEMORY_OVERLAP(pOutProfile, sizeof(*pOutProfile), &profile, sizeof(profile));

    pOutProfile->id = profile.id;
    util::Strlcpy( reinterpret_cast<char*>(pOutProfile->name), profile.name, NetworkProfileBasicInfo::NameSize );
    pOutProfile->networkProfileType = static_cast<Bit8>(profile.networkProfileType);
    pOutProfile->networkInterfaceType = static_cast<Bit8>(profile.networkInterfaceType);
    pOutProfile->isAutoConnect = profile.isAutoConnect;
    pOutProfile->isLargeCapacity = profile.isLargeCapacity;
    pOutProfile->ssid = profile.wirelessSetting.ssidConfig.ssid;
    pOutProfile->nonBroadcast = profile.wirelessSetting.ssidConfig.nonBroadcast;
    pOutProfile->authentication = static_cast<Bit8>(profile.wirelessSetting.security.authEncryption.authentication);
    pOutProfile->encryption = static_cast<Bit8>(profile.wirelessSetting.security.authEncryption.encryption);
    pOutProfile->sharedKey = profile.wirelessSetting.security.sharedKey;
    pOutProfile->ipSetting = profile.ipSetting;
}

void ConvertNetworkProfileDataToNifmFromSf( NetworkProfileData* pOutProfile, const sf::NetworkProfileData& profile ) NN_NOEXCEPT
{
    NN_DETAIL_NIFM_ASSERT_NOT_MEMORY_OVERLAP(pOutProfile, sizeof(*pOutProfile), &profile, sizeof(profile));

    pOutProfile->id = profile.id;
    util::Strlcpy( pOutProfile->name, reinterpret_cast<const char*>(profile.name), NetworkProfileBasicInfo::NameSize);
    pOutProfile->networkProfileType = static_cast<NetworkProfileType>(profile.networkProfileType);
    pOutProfile->networkInterfaceType = static_cast<NetworkInterfaceType>(profile.networkInterfaceType);
    pOutProfile->isAutoConnect = profile.isAutoConnect;
    pOutProfile->isLargeCapacity = profile.isLargeCapacity;
    pOutProfile->wirelessSetting.ssidConfig.ssid = profile.ssid;
    pOutProfile->wirelessSetting.ssidConfig.nonBroadcast = profile.nonBroadcast;
    pOutProfile->wirelessSetting.security.authEncryption.authentication = static_cast<Authentication>(profile.authentication);
    pOutProfile->wirelessSetting.security.authEncryption.encryption = static_cast<Encryption>(profile.encryption);
    pOutProfile->wirelessSetting.security.sharedKey = profile.sharedKey;
    pOutProfile->ipSetting = profile.ipSetting;
}

void ConvertAccessPointDataToSfFromNifm( sf::AccessPointData* pOutAccessPointData, const AccessPointData& accessPoint ) NN_NOEXCEPT
{
    NN_DETAIL_NIFM_ASSERT_NOT_MEMORY_OVERLAP(pOutAccessPointData, sizeof(*pOutAccessPointData), &accessPoint, sizeof(accessPoint));

    pOutAccessPointData->ssid = accessPoint.ssid;
    pOutAccessPointData->bssid = accessPoint.bssid;
    pOutAccessPointData->rssi = accessPoint.rssi;
    pOutAccessPointData->linkLevel = static_cast<Bit8>(accessPoint.linkLevel);
    pOutAccessPointData->channel = accessPoint.channel;
    pOutAccessPointData->authentication = static_cast<Bit8>(accessPoint.authentication);
    pOutAccessPointData->encryption = static_cast<Bit8>(accessPoint.encryption);
    pOutAccessPointData->groupEncryption = static_cast<Bit8>(accessPoint.groupEncryption);
    pOutAccessPointData->isSupported = accessPoint.isSupported;
}

void ConvertAccessPointDataToNifmFromSf(AccessPointData* pOutAccessPointData, const sf::AccessPointData& accessPoint) NN_NOEXCEPT
{
    NN_DETAIL_NIFM_ASSERT_NOT_MEMORY_OVERLAP(pOutAccessPointData, sizeof(*pOutAccessPointData), &accessPoint, sizeof(accessPoint));

    pOutAccessPointData->ssid = accessPoint.ssid;
    pOutAccessPointData->bssid = accessPoint.bssid;
    pOutAccessPointData->rssi = accessPoint.rssi;
    pOutAccessPointData->linkLevel = static_cast<LinkLevel>(accessPoint.linkLevel);
    pOutAccessPointData->channel = accessPoint.channel;
    pOutAccessPointData->authentication = static_cast<Authentication>(accessPoint.authentication);
    pOutAccessPointData->encryption = static_cast<Encryption>(accessPoint.encryption);
    pOutAccessPointData->groupEncryption = static_cast<Encryption>(accessPoint.groupEncryption);
    pOutAccessPointData->isSupported = accessPoint.isSupported;
}

void ConvertNetworkInterfaceInfoToSfFromNifm( sf::NetworkInterfaceInfo* pOutNetworkInterfaceInfo, const NetworkInterfaceInfo& networkInterfaceInfo ) NN_NOEXCEPT
{
    NN_DETAIL_NIFM_ASSERT_NOT_MEMORY_OVERLAP(pOutNetworkInterfaceInfo, sizeof(*pOutNetworkInterfaceInfo), &networkInterfaceInfo, sizeof(networkInterfaceInfo));

    pOutNetworkInterfaceInfo->type = static_cast<Bit8>(networkInterfaceInfo.type);
    pOutNetworkInterfaceInfo->macAddress = networkInterfaceInfo.macAddress;
    pOutNetworkInterfaceInfo->isAvailable = networkInterfaceInfo.isAvailable;
}

void ConvertNetworkInterfaceInfoToNifmFromSf( NetworkInterfaceInfo* pOutNetworkInterfaceInfo, const sf::NetworkInterfaceInfo& networkInterfaceInfo ) NN_NOEXCEPT
{
    NN_DETAIL_NIFM_ASSERT_NOT_MEMORY_OVERLAP(pOutNetworkInterfaceInfo, sizeof(*pOutNetworkInterfaceInfo), &networkInterfaceInfo, sizeof(networkInterfaceInfo));

    pOutNetworkInterfaceInfo->type = static_cast<NetworkInterfaceType>(networkInterfaceInfo.type);
    pOutNetworkInterfaceInfo->macAddress = networkInterfaceInfo.macAddress;
    pOutNetworkInterfaceInfo->isAvailable = networkInterfaceInfo.isAvailable;
}

void ConvertInternetConnectionStatusToSfFromNifm(sf::InternetConnectionStatus* pOutConnectionStatus, const InternetConnectionStatus& connectionInfo) NN_NOEXCEPT
{
    NN_DETAIL_NIFM_ASSERT_NOT_MEMORY_OVERLAP(pOutConnectionStatus, sizeof(*pOutConnectionStatus), &connectionInfo, sizeof(connectionInfo));

    pOutConnectionStatus->networkInterfaceType = static_cast<Bit8>(connectionInfo.networkInterfaceType);
    pOutConnectionStatus->linkLevel = static_cast<Bit8>(connectionInfo.linkLevel);
    pOutConnectionStatus->internetAvailability = static_cast<Bit8>(connectionInfo.internetAvailability);
}

void ConvertInternetConnectionStatusToNifmFromSf(InternetConnectionStatus* pOutConnectionStatus, const sf::InternetConnectionStatus& connectionInfo) NN_NOEXCEPT
{
    NN_DETAIL_NIFM_ASSERT_NOT_MEMORY_OVERLAP(pOutConnectionStatus, sizeof(*pOutConnectionStatus), &connectionInfo, sizeof(connectionInfo));

    pOutConnectionStatus->networkInterfaceType = static_cast<NetworkInterfaceType>(connectionInfo.networkInterfaceType);
    pOutConnectionStatus->linkLevel = static_cast<LinkLevel>(connectionInfo.linkLevel);
    pOutConnectionStatus->internetAvailability = static_cast<InternetAvailability>(connectionInfo.internetAvailability);
}

// 互換性維持のため

void ConvertAccessPointDataToSfFromNifm(sf::AccessPointDataOld* pOutAccessPointData, const AccessPointData& accessPoint) NN_NOEXCEPT
{
    NN_DETAIL_NIFM_ASSERT_NOT_MEMORY_OVERLAP(pOutAccessPointData, sizeof(*pOutAccessPointData), &accessPoint, sizeof(accessPoint));

    pOutAccessPointData->ssid = accessPoint.ssid;
    pOutAccessPointData->bssid = accessPoint.bssid;
    pOutAccessPointData->rssi = accessPoint.rssi;
    pOutAccessPointData->linkLevel = static_cast<Bit8>(accessPoint.linkLevel);
    pOutAccessPointData->channel = accessPoint.channel;
    pOutAccessPointData->authentication = static_cast<Bit8>(accessPoint.authentication);
    pOutAccessPointData->encryption = static_cast<Bit8>(accessPoint.encryption);
    pOutAccessPointData->groupEncryption = static_cast<Bit8>(accessPoint.groupEncryption);
}

void ConvertAccessPointDataToNifmFromSf(AccessPointData* pOutAccessPointData, const sf::AccessPointDataOld& accessPoint) NN_NOEXCEPT
{
    NN_DETAIL_NIFM_ASSERT_NOT_MEMORY_OVERLAP(pOutAccessPointData, sizeof(*pOutAccessPointData), &accessPoint, sizeof(accessPoint));

    pOutAccessPointData->ssid = accessPoint.ssid;
    pOutAccessPointData->bssid = accessPoint.bssid;
    pOutAccessPointData->rssi = accessPoint.rssi;
    pOutAccessPointData->linkLevel = static_cast<LinkLevel>(accessPoint.linkLevel);
    pOutAccessPointData->channel = accessPoint.channel;
    pOutAccessPointData->authentication = static_cast<Authentication>(accessPoint.authentication);
    pOutAccessPointData->encryption = static_cast<Encryption>(accessPoint.encryption);
    pOutAccessPointData->groupEncryption = static_cast<Encryption>(accessPoint.groupEncryption);
}

}
}
}
