﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/detail/core/connectionConfirmation/nifm_HttpPostData.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_StringUtil.h>
#include <nn/nn_SdkLog.h>

namespace nn
{
namespace nifm
{
namespace detail
{

HttpPostData::HttpPostData() NN_NOEXCEPT
    : m_Length(0)
{
}

HttpPostData::~HttpPostData() NN_NOEXCEPT
{
}

nn::Result HttpPostData::EncodeAdd(const char* pKey, const char* pValue, int size, Base64::Mode mode) NN_NOEXCEPT
{
    if (m_Length)
    {
        m_Buffer[m_Length++] = '&';
    }

    int keySize = nn::util::Strnlen(pKey, Size - m_Length);
    memcpy(&m_Buffer[m_Length], pKey, keySize);
    m_Length += keySize;

    m_Buffer[m_Length++] = '=';

    size_t count;
    auto status = Base64::ToBase64String(&count, &m_Buffer[m_Length], Size - m_Length, pValue, size, mode);
    NN_RESULT_THROW_UNLESS(status == Base64::Status_Success, ResultInvalidArgument());
    m_Length += static_cast<int>(count);
    m_Buffer[m_Length] = '\0';

    NN_RESULT_SUCCESS;
}

nn::Result HttpPostData::DecodeAdd(const char* pValue, Base64::Mode mode) NN_NOEXCEPT
{
    size_t count;
    auto status = Base64::FromBase64String(&count, &m_Buffer[m_Length], Size - m_Length, pValue, mode);
    NN_RESULT_THROW_UNLESS(status == Base64::Status_Success, ResultInvalidArgument());
    m_Length += static_cast<int>(count);
    m_Buffer[m_Length] = '\0';

    NN_RESULT_SUCCESS;
}

const char* HttpPostData::GetPointer() const NN_NOEXCEPT
{
    return m_Buffer;
}

int HttpPostData::GetLength() const NN_NOEXCEPT
{
    return m_Length;
}

void HttpPostData::Clear() NN_NOEXCEPT
{
    m_Buffer[0] = '\0';
    m_Length = 0;
}

}
}
}
