﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_FormatString.h>
#include <nn/util/util_StringUtil.h>

namespace nn {
namespace ngc {

    // 文字列長を取得します
    size_t wcslen( const char16_t* pString ) NN_NOEXCEPT;

    // 文字列をコピーします
    int wcsncmp(
        const char16_t* pString1,
        const char16_t* pString2,
        size_t count
    ) NN_NOEXCEPT;

    // 文字列をコピーします
    char* strncpy(char* pString1, const char* pString2, size_t count) NN_NOEXCEPT;

    // メモリに値をセットします
    void* memset(void* buf, int character, size_t count) NN_NOEXCEPT;

}   // namespace ngc
}   // namespace nn

