﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/nn_SdkAssert.h>

#include "../ngc_Private.h"

namespace nn { namespace ngc { namespace detail {

extern const Bit8 VersionFilterPatternData[];
extern const uint32_t VersionFilterPatternDataLength;

nn::Result GetFilterVersionData( void* pData, uint32_t size ) NN_NOEXCEPT
{
    std::memcpy( pData, VersionFilterPatternData, size );

    return nn::ResultSuccess();
}

nn::Result GetFilterVersionDataLength( uint32_t* pSize ) NN_NOEXCEPT
{
    *pSize = VersionFilterPatternDataLength;

    return nn::ResultSuccess();
}

}}} // nn::ngc::detail
