﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nfp/nfp_Types.h>
#include <nn/nfc/server/core/nfc_Types.h>
#include <nn/nfp/nfp_Result.h>
#include <nn/nfp/nfp_PrivateResult.h>

namespace nn { namespace nfp { namespace server {

void FillRandom(void* pOutBuffer, size_t bufferSize) NN_NOEXCEPT;
nn::Bit64 Random64() NN_NOEXCEPT;
nn::Bit32 Random32() NN_NOEXCEPT;
nn::Bit16 Random16() NN_NOEXCEPT;
nn::Bit8 Random8() NN_NOEXCEPT;
nn::Bit32 Crc32(const void* pData, size_t dataSize) NN_NOEXCEPT;

}}}  // namespace nn::nfp::server
