﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nn/nn_Abort.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nfc/server/core/nfc_Result.h>
#include <nn/nfc/server/core/nfc_CoreUtil.h>
#include "nfp_Util.h"

namespace nn { namespace nfp {namespace server {

void FillRandom(void* pOutBuffer, size_t bufferSize) NN_NOEXCEPT
{
    nn::Bit8* out = static_cast<nn::Bit8*>(pOutBuffer);
    for (auto i = 0U; i < bufferSize; ++i)
    {
        out[i] = Random8();
    }
}

nn::Bit64 Random64() NN_NOEXCEPT
{
    return (static_cast<nn::Bit64>(std::rand() & 0xFFFF) << 48) |
        (static_cast<nn::Bit64>(std::rand() & 0xFFFF) << 32) |
        (static_cast<nn::Bit64>(std::rand() & 0xFFFF) << 16) |
        (static_cast<nn::Bit64>(std::rand() & 0xFFFF));
}

nn::Bit32 Random32() NN_NOEXCEPT
{
    return static_cast<nn::Bit32>((std::rand() << 16) | (std::rand() & 0xFFFF));
}

nn::Bit16 Random16() NN_NOEXCEPT
{
    return static_cast<nn::Bit16>(std::rand() & 0xFFFF);
}

nn::Bit8 Random8() NN_NOEXCEPT
{
    return static_cast<nn::Bit8>(std::rand() & 0xFF);
}

nn::Bit32 Crc32(const void* pData, size_t dataSize) NN_NOEXCEPT
{
    const nn::Bit8* c = reinterpret_cast<const nn::Bit8*>(pData);
    const nn::Bit32 CrcPoly2 = 0xEDB88320;
    const size_t CharBit = 8;
    nn::Bit32 r;
    size_t i, j;

    r = 0xFFFFFFFF;
    for(i = 0; i < dataSize; i++)
    {
        r ^= c[i];

        for (j = 0; j < CharBit; j++)
        {
            if (r & 1)
            {
                r = (r >> 1) ^ CrcPoly2;
            }
            else
            {
                r >>= 1;
            }
        }
    }
    return r ^ 0xFFFFFFFF;
}

}}}  // namespace nn::nfp::server
