﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_SystemEvent.h>
#include <nn/nfp/nfp_Result.h>
#include <nn/nfp/nfp_PrivateResult.h>
#include <nn/nfp/nfp_DebugTypes.h>
#include <nn/nfp/nfp_PrivateTypes.h>
#include <nn/nfp/nfp_Types.h>
#include "nfp_Ntag.h"
#include "nfp_DataNode.h"
#include "nfp_Keys.h"

namespace nn { namespace nfp { namespace server {

namespace
{
struct CommonBlockData;
}

class Noft2 : public Ntag
{
public:
    static const size_t DataSize = 540;

    // NOFT Version 2 は 3 つのストリームをもちます。
    static const int StreamCount                           = 3;

    enum State
    {
        State_Init,
        State_Mount,
    };

public:
    Noft2(const nn::nfc::DeviceHandle& deviceHandle, const nn::nfc::TagId& id, nn::os::SystemEventType* accessFinishEvent, nn::os::SystemEventType* accessResetEvent) NN_NOEXCEPT;
    virtual ~Noft2() NN_NOEXCEPT;
    nn::Result Mount(nn::nfc::server::core::Service* service, nn::nfp::MountTarget mountTarget) NN_NOEXCEPT;
    nn::Result Unmount() NN_NOEXCEPT;
    nn::Result OpenApplicationArea(nn::Bit32 accessId) NN_NOEXCEPT;
    nn::Result GetApplicationArea(void* pOutBuffer, size_t* pOutSize, size_t bufferSize) NN_NOEXCEPT;
    nn::Result SetApplicationArea(const void* pData, size_t dataSize) NN_NOEXCEPT;
    nn::Result RecreateApplicationArea(const nn::nfp::ApplicationAreaCreateInfo& createInfo) NN_NOEXCEPT;
    nn::Result Flush(nn::nfc::server::core::Service* service) NN_NOEXCEPT;
    nn::Result Restore(nn::nfc::server::core::Service* service) NN_NOEXCEPT;
    nn::Result CreateApplicationArea(nn::nfc::server::core::Service* service, const nn::nfp::ApplicationAreaCreateInfo& createInfo) NN_NOEXCEPT;
    nn::Result GetRegisterInfo(nn::nfp::RegisterInfo* pOutRegisterInfo) NN_NOEXCEPT;
    nn::Result GetCommonInfo(nn::nfp::CommonInfo* pOutCommonInfo) NN_NOEXCEPT;
    nn::Result GetModelInfo(nn::nfp::ModelInfo* pOutModelInfo) NN_NOEXCEPT;
    nn::Result Format(nn::nfp::ModelInfo* pOutModelInfo, nn::nfc::server::core::Service* service) NN_NOEXCEPT;
    nn::Result GetAdminInfo(nn::nfp::AdminInfo* pOutAdminInfo) NN_NOEXCEPT;
    nn::Result GetRegisterInfo(nn::nfp::RegisterInfoPrivate* pOutRegisterInfo) NN_NOEXCEPT;
    nn::Result SetRegisterInfo(const nn::nfp::RegisterInfoPrivate& regInfo) NN_NOEXCEPT;
    nn::Result DeleteRegisterInfo(nn::nfc::server::core::Service* service) NN_NOEXCEPT;
    nn::Result DeleteApplicationArea(nn::nfc::server::core::Service* service) NN_NOEXCEPT;
    nn::Result ExistsApplicationArea(bool* outValue) NN_NOEXCEPT;
    nn::Result GetAll(nn::nfp::NfpData* pOutNfpData) NN_NOEXCEPT;
    nn::Result SetAll(const nn::nfp::NfpData& nfpData) NN_NOEXCEPT;
    nn::Result FlushDebug(nn::nfc::server::core::Service* service) NN_NOEXCEPT;
    nn::Result BreakTag(nn::nfc::server::core::Service* service, BreakType breakType) NN_NOEXCEPT;
    static size_t GetApplicationAreaSize() NN_NOEXCEPT;
    bool IsMountedRam() NN_NOEXCEPT;
    bool IsMountedRom() NN_NOEXCEPT;
    nn::Result CreateUserMemory(void* pOutPhysicalData, nn::nfc::server::core::Service* service, size_t physicalDataSize, const void* pData, size_t dataSize) NN_NOEXCEPT;
    nn::Result WriteUserMemory(nn::nfc::server::core::Service* service, const void* encryptedPhysicalData, size_t encryptedPhysicalDataSize) NN_NOEXCEPT;
    nn::Result WriteConfigureAndLock(nn::nfc::server::core::Service* service, const void* encryptedPhysicalData, size_t encryptedPhysicalDataSize, NtfWriteType ntfWriteType) NN_NOEXCEPT;

private:
    Noft2() NN_NOEXCEPT;
    nn::Result ReadPhysicalData(void* pOutPhysicalData, nn::nfc::server::core::Service* service, size_t physicalDataSize) NN_NOEXCEPT;
    nn::Result WritePhysicalData(nn::nfc::server::core::Service* service, const void* pPhysicalData, size_t physicalDataSize, bool readyToWrite) NN_NOEXCEPT;
    void SetState(Noft2::State state) NN_NOEXCEPT;
    nn::Result FlushNormal(nn::nfc::server::core::Service* service) NN_NOEXCEPT;
    nn::Result FlushCommon(nn::nfc::server::core::Service* service, nn::nfp::BreakType breakType) NN_NOEXCEPT;
    nn::Result CreatePhysicalDataForFlush(void* pOutPhysicalData, size_t physicalDataSize) NN_NOEXCEPT;
    nn::Result CreatePhysicalDataForFormat(void* pOutPhysicalData, nn::nfc::server::core::Service* service, size_t physicalDataSize) NN_NOEXCEPT;
    bool IsMounted() NN_NOEXCEPT;
    void UpdateMoveCounter(CommonBlockData* commonBlockData) NN_NOEXCEPT;
    void UpdateWriteDate(CommonBlockData* commonBlockData) NN_NOEXCEPT;
    nn::Result ReadyToWrite(nn::nfc::server::core::Service* service, bool isPasswordRequired) NN_NOEXCEPT;
    void GetPwd(void* pOutBuffer, size_t bufferSize) NN_NOEXCEPT;

private:
    Noft2::State m_State;
    nn::Bit8 m_LogicalData[DataSize];
    nn::nfp::MountTarget m_MountTarget;
    DataNode m_LogicalDataNode[StreamCount];

    bool m_IsUpdatedAppBlock;
    bool m_IsCreatedRegisterInfo;
    bool m_IsOpenedApplicationArea;
};
}}}  // namespace nn::nfp::server
