﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nfp/nfp_Types.h>
#include <nn/nfc/nfc_Result.h>
#include <nn/nfc/nfc_PrivateResult.h>
#include <nn/nfc/nfc_NfpResult.internal.h>

namespace nn { namespace nfp { namespace server {

//! バックアップデータのヘッダを示す構造体です。
struct BackupDataHeader
{
    uint8_t formatVersion;                   //!< バックアップフォーマットバージョン
    nn::Bit8 updateFlag;                     //!< バックアップデータの更新フラグ
    uint16_t entryNum;                       //!< 使用済みのバックアップデータのエントリ数
    uint16_t nextEntryIndex;                 //!< 次に書き込むエントリの番号
    nn::Bit8 reserved[22];                    //!< 予約
    nn::Bit32 hash;                          //!< ヘッダのハッシュ (CRC32)

    void Recalculate() NN_NOEXCEPT;
    void Clear() NN_NOEXCEPT;
    nn::Result Verify(uint16_t entryMax) const NN_NOEXCEPT;
};

}}}  // namespace nn::nfp::server
