﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkLog.h>
#include <nn/result/result_HandlingUtility.h>
#include "nfp_BackupDataHeader.h"
#include "nfp_Util.h"

namespace nn {
namespace nfp {
namespace server {

void BackupDataHeader::Recalculate() NN_NOEXCEPT
{
    this->hash = Crc32(this, sizeof(BackupDataHeader) - 4);
}

void BackupDataHeader::Clear() NN_NOEXCEPT
{
    std::memset(this, 0, sizeof(BackupDataHeader));
    Recalculate();
}

nn::Result BackupDataHeader::Verify(uint16_t entryMax) const NN_NOEXCEPT
{
    nn::Bit32 crc = Crc32(this, sizeof(BackupDataHeader) - 4);
    if (crc != this->hash)
    {
        return nn::nfc::ResultBackupCrcBroken();
    }
    else if (this->entryNum > entryMax || this->nextEntryIndex >= entryMax)
    {
        return nn::nfc::ResultBackupReadFailed();
    }
    else
    {
        NN_RESULT_SUCCESS;
    }
}

} // end of namespace server
} // end of namespace nfp
} // end of namespace nn
