﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nfp/nfp_Lib.h>
#include <nn/nfp/nfp_ErrorApi.h>
#include <nn/applet/applet.h>
#include "client/nfp_UserInterface.h"
#include "client/nfp_SystemInterface.h"
#include "client/nfp_DebugInterface.h"
#include "client/nfp_McuVersionData.h"
#include "detail/nfp_Util.h"

namespace nn { namespace nfp {

namespace client {

const nn::xcd::McuVersionDataForNfc RequiredMcuVersionData[] =
{
    { 3, 10, nn::xcd::DeviceType_Right },
    { 3,  4, nn::xcd::DeviceType_FullKey }
};

const int RequiredMcuVersionDataCount =
    sizeof(RequiredMcuVersionData) / sizeof(RequiredMcuVersionData[0]);

}  // client

void Initialize() NN_NOEXCEPT
{
    NN_ABORT_UNLESS(!client::IsCreatedDebugInterface());
    NN_ABORT_UNLESS(!client::IsCreatedSystemInterface());
    NN_ABORT_UNLESS(!client::IsCreatedUserInterface());

    client::CreateUserInterface();

    nn::sf::InArray<nn::xcd::McuVersionDataForNfc> requiredVersions(
        client::RequiredMcuVersionData,
        client::RequiredMcuVersionDataCount);

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    nn::applet::AppletResourceUserId id = nn::applet::GetAppletResourceUserId();
    NN_ABORT_UNLESS_RESULT_SUCCESS(client::GetUserInterface()->InitializeNfp(id, 0, requiredVersions));
#else
    nn::applet::AppletResourceUserId id = nn::applet::AppletResourceUserId::GetInvalidId();
    NN_ABORT_UNLESS_RESULT_SUCCESS(client::GetUserInterface()->InitializeNfp(id, 1, requiredVersions));
#endif

    SetErrorVisible(true);
}

void Finalize() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(client::GetUserInterface()->FinalizeNfp());
    client::DestroyUserInterface();
}

}}
