﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "client/nfp_CommonInterface.h"

namespace nn { namespace nfp {

namespace
{
bool g_IsErrorVisible = true;
}

void SetErrorVisible(bool visible) NN_NOEXCEPT
{
    NN_ABORT_UNLESS(client::IsCreatedDebugInterface() || client::IsCreatedSystemInterface() || client::IsCreatedUserInterface());

    g_IsErrorVisible = visible;
}

bool IsErrorVisible() NN_NOEXCEPT
{
    NN_ABORT_UNLESS(client::IsCreatedDebugInterface() || client::IsCreatedSystemInterface() || client::IsCreatedUserInterface());

    return g_IsErrorVisible;
}

}}
