﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sf/sf_Types.h>
#include <nn/nfp/detail/nfp_ISystem.h>

namespace nn {
namespace nfp {
namespace client {

void CreateSystemInterface() NN_NOEXCEPT;
nn::sf::SharedPointer<nn::nfp::detail::ISystem>GetSystemInterface() NN_NOEXCEPT;
void DestroySystemInterface() NN_NOEXCEPT;
bool IsCreatedSystemInterface() NN_NOEXCEPT;

}  // client
}  // nfp
}  // nn
