﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nfc/server/util/nfc_ScopedLockShared.h>

namespace nn { namespace nfc { namespace server { namespace util {

ScopedLockShared::ScopedLockShared(nn::os::ReaderWriterLock& rwLock) NN_NOEXCEPT : m_rwLock(rwLock)
{
    m_rwLock.lock_shared();
}

ScopedLockShared::~ScopedLockShared() NN_NOEXCEPT
{
    m_rwLock.unlock_shared();
}

}}}}  // namespace nn::nfc::server::util
