﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "nfc_CoreTag.h"

namespace nn { namespace nfc { namespace server { namespace core {

    class Ntag : public Tag
    {
        NN_DISALLOW_COPY(Ntag);
        NN_DISALLOW_MOVE(Ntag);

    public:
        explicit Ntag(nn::xcd::DeviceHandle xcdDeviceHandle, const nn::nfc::TagId& id) NN_NOEXCEPT : Tag(xcdDeviceHandle, id, nn::nfc::NfcProtocol_TypeA, nn::nfc::TagType_Type2){}
        virtual ~Ntag() NN_NOEXCEPT {};
        nn::Result StartRead(const NtagReadParameter& ntagReadParameter) NN_NOEXCEPT;
        nn::Result StartWrite(const NtagWriteParameter& ntagWriteParameter) NN_NOEXCEPT;
    private:
        Ntag() NN_NOEXCEPT;
    };

}}}}  // namespace nn::nfc::server::core
