﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using Nintendo.ServiceFramework.Applet;
using nn;
using nn.sf;
using std;

namespace nn.nfc
{
    [ExternalStruct(8, 4)]
    [CppRefPath("<nn/nfc/nfc_Types.h>")]
    public struct DeviceHandle
    {
    }

    [ExternalStruct(88, 4)]
    [CppRefPath("<nn/nfc/nfc_Types.h>")]
    [LargeData(true)]
    public struct TagInfo
    {
    }
}

namespace nn.nfc
{
    [ExternalStruct(1, 1)]
    [CppRefPath("<nn/nfc/nfc_MifareTypes.h>")]
    public struct MifareKeyId
    {
    }

    [ExternalStruct(24, 1)]
    [CppRefPath("<nn/nfc/nfc_MifareTypes.h>")]
    public struct MifareReadBlockData
    {
    }

    [ExternalStruct(24, 1)]
    [CppRefPath("<nn/nfc/nfc_MifareTypes.h>")]
    public struct MifareReadBlockParameter
    {
    }

    [ExternalStruct(40, 1)]
    [CppRefPath("<nn/nfc/nfc_MifareTypes.h>")]
    public struct MifareWriteBlockParameter
    {
    }
}

namespace nn.applet
{
    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct AppletResourceUserId
    {
    }

    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [CheckAppletResourceUserId]
    [CppFullName("nn::applet::AppletResourceUserId")]
    [ExternalStruct(8, 8)]
    public struct CheckedAppletResourceUserId
    {
    }
}

namespace nn.hid
{
    [ExternalStruct(4, 4)]
    [CppRefPath("<nn/hid/hid_NpadCommonTypes.h>")]
    public struct NpadIdType
    {
    }
}

namespace nn.xcd
{
    [ExternalStruct(32, 2)]
    [CppRefPath("<nn/xcd/xcd_NfcTypes.h>")]
    public struct McuVersionDataForNfc
    {
    }
}

namespace nn.nfc.mifare.detail
{
    public interface IUser : IServiceObject
    {
        [MethodId(0)]
        Result
            InitializeNfcMifare(
                nn.applet.CheckedAppletResourceUserId aruid,
                [ProcessId] Bit64 pid,
                [BufferTransferMode(BufferTransferMode.MapAlias)] nn.sf.InArray<nn.xcd.McuVersionDataForNfc> mcuVersionData
            );

        [MethodId(1)]
        Result
            FinalizeNfcMifare(
            );

        [MethodId(2)]
        Result
            ListDevicesNfcMifare(
                nn.sf.OutArray<nn.nfc.DeviceHandle> devices,
                nn.sf.Out<int32_t> count
            );

        [MethodId(3)]
        Result
            StartDetectionNfcMifare(
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(4)]
        Result
            StopDetectionNfcMifare(
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(5)]
        Result
            ReadNfcMifare(
                [BufferTransferMode(BufferTransferMode.MapAlias)] nn.sf.OutArray<nn.nfc.MifareReadBlockData> blockData,
                nn.nfc.DeviceHandle deviceHandle,
                [BufferTransferMode(BufferTransferMode.MapAlias)] nn.sf.InArray<nn.nfc.MifareReadBlockParameter> blockParameter
            );

        [MethodId(6)]
        Result
            WriteNfcMifare(
                nn.nfc.DeviceHandle deviceHandle,
                [BufferTransferMode(BufferTransferMode.MapAlias)] nn.sf.InArray<nn.nfc.MifareWriteBlockParameter> blockParameter
            );

        [MethodId(7)]
        Result
            GetTagInfoNfcMifare(
                Out<nn.nfc.TagInfo> tagInfo,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(8)]
        Result
            GetActivateEventHandleNfcMifare(
                Out<NativeHandle> handle,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(9)]
        Result
            GetDeactivateEventHandleNfcMifare(
                Out<NativeHandle> handle,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(10)]
        Result
            GetStateNfcMifare(
                Out<nn.Bit32> state
            );

        [MethodId(11)]
        Result
            GetDeviceStateNfcMifare(
                Out<nn.Bit32> state,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(12)]
        Result
            GetNpadIdNfcMifare(
                Out<nn.hid.NpadIdType> npadId,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(13)]
        Result
            GetAvailabilityChangeEventHandleNfcMifare(
                Out<NativeHandle> handle
            );
    }

    public interface IUserManager : IServiceObject
    {
        [MethodId(0)]
        Result CreateUserInterface(
            Out<IUser> pOutUserInterface
        );
    }
}
