﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SystemThreadDefinition.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nfc/server/core/nfc_CoreManager.h>
#include <nn/nfc/server/util/nfc_ScopedLockShared.h>
#include <nn/nfc/mifare/server/nfc_MifareManager.h>
#include <nn/nfc/server/nfc_Manager.h>
#include <nn/nfc/server/util/nfc_UtilUtil.h>

namespace nn { namespace nfc { namespace mifare { namespace server {

namespace
{
}

Manager::Manager(nn::nfc::server::Manager* manager) NN_NOEXCEPT : m_Manager(manager)
{
}

Manager::~Manager() NN_NOEXCEPT
{
}

nn::Result Manager::Read(nn::nfc::MifareReadBlockData* pOutBlockData, nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle, const nn::nfc::MifareReadBlockParameter* pBlockParameter, size_t blockCount) NN_NOEXCEPT
{
    nn::nfc::server::util::ScopedLockShared lock(m_Manager->m_ReaderWriterLock);

    NN_NFC_SERVER_MANAGER_ACCESS_DEVICE_RETURN(m_Manager, service, deviceHandle, ReadMifare(pOutBlockData, service, pBlockParameter, blockCount));
}

nn::Result Manager::Write(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle, const nn::nfc::MifareWriteBlockParameter* pBlockParameter, size_t blockCount) NN_NOEXCEPT
{
    nn::nfc::server::util::ScopedLockShared lock(m_Manager->m_ReaderWriterLock);

    NN_NFC_SERVER_MANAGER_ACCESS_DEVICE_RETURN(m_Manager, service, deviceHandle, WriteMifare(service, pBlockParameter, blockCount));
}

}}}}  // namespace nn::nfc::mifare::server
