﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nfc/am/nfc_AmLib.h>
#include "client/nfc_AmInterface.h"

namespace nn { namespace nfc { namespace am {

void Initialize() NN_NOEXCEPT
{
    NN_ABORT_UNLESS(!client::IsCreatedAmInterface());

    client::CreateAmInterface();

    client::GetAmInterface()->Initialize();
}

void Finalize() NN_NOEXCEPT
{
    client::GetAmInterface()->Finalize();
    client::DestroyAmInterface();
}

void NotifyForegroundApplet(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
{
    client::GetAmInterface()->NotifyForegroundApplet(aruid);
}

}}}
